# -* makefile -*- GNU Makefile for NetWare target

PROOT=.
OBJDIR=release

-include $(OBJDIR)/version.inc

TARGETS=nasm.nlm ndisasm.nlm

PERL=perl

CROSSPREFIX=i586-netware-

CC=$(CROSSPREFIX)gcc
LD=$(CC)

BINSUFFIX=.nlm

VERSION=$(NASM_MAJOR_VER).$(NASM_MINOR_VER).$(NASM_SUBMINOR_VER)

CFLAGS=-g -O2 -Wall -std=c99 -pedantic -D__NETWARE__ -D_POSIX_SOURCE -DHAVE_CONFIG_H -I.
LDFLAGS=-Wl,--nlm-description="NASM $(NASM_VER) - the Netwide Assembler (gcc build)"
LDFLAGS+=-Wl,--nlm-copyright="NASM is licensed under LGPL."
LDFLAGS+=-Wl,--nlm-version=$(VERSION)
LDFLAGS+=-Wl,--nlm-kernelspace
LDFLAGS+=-Wl,--nlm-posixflag
LDFLAGS+=-s

NASM_OBJ = \
	$(OBJDIR)/nasm.o\
	$(OBJDIR)/nasmlib.o\
	$(OBJDIR)/float.o\
	$(OBJDIR)/insnsa.o\
	$(OBJDIR)/assemble.o\
	$(OBJDIR)/labels.o\
	$(OBJDIR)/hashtbl.o\
	$(OBJDIR)/crc64.o\
	$(OBJDIR)/parser.o\
	$(OBJDIR)/outform.o\
	$(OBJDIR)/outbin.o\
	$(OBJDIR)/outaout.o\
	$(OBJDIR)/outcoff.o\
	$(OBJDIR)/outelf32.o\
	$(OBJDIR)/outelf64.o\
	$(OBJDIR)/outobj.o\
	$(OBJDIR)/outas86.o\
	$(OBJDIR)/outrdf2.o\
	$(OBJDIR)/outdbg.o\
	$(OBJDIR)/outieee.o\
	$(OBJDIR)/outmacho.o\
	$(OBJDIR)/preproc.o\
	$(OBJDIR)/pptok.o\
	$(OBJDIR)/listing.o\
	$(OBJDIR)/eval.o\
	$(OBJDIR)/exprlib.o\
	$(OBJDIR)/stdscan.o\
	$(OBJDIR)/tokhash.o\
	$(EOLIST)

NDIS_OBJ = \
	$(OBJDIR)/ndisasm.o\
	$(OBJDIR)/nasmlib.o\
	$(OBJDIR)/disasm.o\
	$(OBJDIR)/sync.o\
	$(OBJDIR)/insnsd.o\
	$(EOLIST)

VPATH  = *.c $(PROOT) $(PROOT)/output


all: $(OBJDIR) config.h $(TARGETS)

$(OBJDIR)/%.o: %.c
	$(CC) $(CFLAGS) -c -o $@ $<

nasm$(BINSUFFIX): $(NASM_OBJ)
	$(LD) $(LDFLAGS) -o $@ $^

ndisasm$(BINSUFFIX): $(NDIS_OBJ)
	$(LD) $(LDFLAGS) -o $@ $^

$(OBJDIR):
	@mkdir $@

config.h: $(PROOT)/Mkfiles/netware.mak
	@echo Creating $@
	@echo $(DL)/* $@ for NetWare target.$(DL) > $@
	@echo $(DL)** Do not edit this file - it is created by make!$(DL) >> $@
	@echo $(DL)** All your changes will be lost!!$(DL) >> $@
	@echo $(DL)*/$(DL) >> $@
	@echo $(DL)#ifndef __NETWARE__$(DL) >> $@
	@echo $(DL)#error This $(notdir $@) is created for NetWare platform!$(DL) >> $@
	@echo $(DL)#endif$(DL) >> $@
	@echo $(DL)#define PACKAGE_VERSION "$(NASM_VER)"$(DL) >> $@
	@echo $(DL)#define OS "i586-pc-libc-NetWare"$(DL) >> $@
	@echo $(DL)#define HAVE_DECL_STRCASECMP 1$(DL) >> $@
	@echo $(DL)#define HAVE_DECL_STRICMP 1$(DL) >> $@
	@echo $(DL)#define HAVE_DECL_STRNCASECMP 1$(DL) >> $@
	@echo $(DL)#define HAVE_DECL_STRNICMP 1$(DL) >> $@
	@echo $(DL)#define HAVE_INTTYPES_H 1$(DL) >> $@
	@echo $(DL)#define HAVE_LIMITS_H 1$(DL) >> $@
	@echo $(DL)#define HAVE_MEMORY_H 1$(DL) >> $@
	@echo $(DL)#define HAVE_SNPRINTF 1$(DL) >> $@
	@echo $(DL)#define HAVE_STDBOOL_H 1$(DL) >> $@
	@echo $(DL)#define HAVE_STDINT_H 1$(DL) >> $@
	@echo $(DL)#define HAVE_STDLIB_H 1$(DL) >> $@
	@echo $(DL)#define HAVE_STRCASECMP 1$(DL) >> $@
	@echo $(DL)#define HAVE_STRCSPN 1$(DL) >> $@
	@echo $(DL)#define HAVE_STRICMP 1$(DL) >> $@
	@echo $(DL)#define HAVE_STRINGS_H 1$(DL) >> $@
	@echo $(DL)#define HAVE_STRING_H 1$(DL) >> $@
	@echo $(DL)#define HAVE_STRNCASECMP 1$(DL) >> $@
	@echo $(DL)#define HAVE_STRNICMP 1$(DL) >> $@
	@echo $(DL)#define HAVE_STRSPN 1$(DL) >> $@
	@echo $(DL)#define HAVE_SYS_STAT_H 1$(DL) >> $@
	@echo $(DL)#define HAVE_SYS_TYPES_H 1$(DL) >> $@
	@echo $(DL)#define HAVE_UNISTD_H 1$(DL) >> $@
	@echo $(DL)#define HAVE_VSNPRINTF 1$(DL) >> $@
	@echo $(DL)#define STDC_HEADERS 1$(DL) >> $@
	@echo $(DL)#ifndef _GNU_SOURCE$(DL) >> $@
	@echo $(DL)#define _GNU_SOURCE 1$(DL) >> $@
	@echo $(DL)#endif$(DL) >> $@
	@echo $(DL)#define ldiv __CW_ldiv$(DL) >> $@

clean:
	-$(RM) -r $(OBJDIR)
	-$(RM) config.h

distclean: clean
	-$(RM) $(TARGETS)

$(OBJDIR)/version.inc: $(PROOT)/version $(PROOT)/version.pl $(OBJDIR)
	@$(PERL) $(PROOT)/version.pl make < $< > $@

#-- Magic hints to mkdep.pl --#
# @object-ending: ".o"
# @path-separator: "/"
# @continuation: "\"
#-- Everything below is generated by mkdep.pl - do not edit --#
assemble.o: assemble.c assemble.h compiler.h config.h insns.h insnsi.h \
 nasm.h nasmlib.h pptok.h preproc.h regflags.c regs.h regvals.c tokens.h \
 version.h
crc64.o: crc64.c compiler.h config.h
disasm.o: disasm.c compiler.h config.h disasm.h insns.h insnsi.h insnsn.c \
 names.c nasm.h nasmlib.h regdis.c regs.c regs.h sync.h tokens.h version.h
eval.o: eval.c compiler.h config.h eval.h float.h insnsi.h labels.h nasm.h \
 nasmlib.h regs.h version.h
exprlib.o: exprlib.c compiler.h config.h insnsi.h nasm.h nasmlib.h regs.h \
 version.h
float.o: float.c compiler.h config.h float.h insnsi.h nasm.h nasmlib.h \
 regs.h version.h
hashtbl.o: hashtbl.c compiler.h config.h hashtbl.h insnsi.h nasm.h nasmlib.h \
 regs.h version.h
insnsa.o: insnsa.c compiler.h config.h insns.h insnsi.h nasm.h nasmlib.h \
 regs.h tokens.h version.h
insnsd.o: insnsd.c compiler.h config.h insns.h insnsi.h nasm.h nasmlib.h \
 regs.h tokens.h version.h
insnsn.o: insnsn.c
labels.o: labels.c compiler.h config.h hashtbl.h insnsi.h nasm.h nasmlib.h \
 regs.h version.h
lib/snprintf.o: lib/snprintf.c compiler.h config.h nasmlib.h
lib/vsnprintf.o: lib/vsnprintf.c compiler.h config.h nasmlib.h
listing.o: listing.c compiler.h config.h insnsi.h listing.h nasm.h nasmlib.h \
 regs.h version.h
macros.o: macros.c compiler.h config.h
names.o: names.c compiler.h config.h insnsn.c regs.c
nasm.o: nasm.c assemble.h compiler.h config.h eval.h float.h insns.h \
 insnsi.h labels.h listing.h nasm.h nasmlib.h outform.h parser.h pptok.h \
 preproc.h regs.h stdscan.h tokens.h version.h
nasmlib.o: nasmlib.c compiler.h config.h insns.h insnsi.h nasm.h nasmlib.h \
 regs.h tokens.h version.h
ndisasm.o: ndisasm.c compiler.h config.h disasm.h insns.h insnsi.h nasm.h \
 nasmlib.h regs.h sync.h tokens.h version.h
outform.o: outform.c compiler.h config.h insnsi.h nasm.h nasmlib.h outform.h \
 regs.h version.h
output/outaout.o: output/outaout.c compiler.h config.h insnsi.h nasm.h \
 nasmlib.h outform.h regs.h stdscan.h version.h
output/outas86.o: output/outas86.c compiler.h config.h insnsi.h nasm.h \
 nasmlib.h outform.h regs.h version.h
output/outbin.o: output/outbin.c compiler.h config.h eval.h insnsi.h \
 labels.h nasm.h nasmlib.h outform.h regs.h stdscan.h version.h
output/outcoff.o: output/outcoff.c compiler.h config.h insnsi.h nasm.h \
 nasmlib.h outform.h regs.h version.h
output/outdbg.o: output/outdbg.c compiler.h config.h insnsi.h nasm.h \
 nasmlib.h outform.h regs.h version.h
output/outelf32.o: output/outelf32.c compiler.h config.h insnsi.h nasm.h \
 nasmlib.h outform.h regs.h stdscan.h version.h
output/outelf64.o: output/outelf64.c compiler.h config.h insnsi.h nasm.h \
 nasmlib.h outform.h regs.h stdscan.h version.h
output/outieee.o: output/outieee.c compiler.h config.h insnsi.h nasm.h \
 nasmlib.h outform.h regs.h version.h
output/outmacho.o: output/outmacho.c compiler.h config.h insnsi.h nasm.h \
 nasmlib.h outform.h regs.h version.h
output/outobj.o: output/outobj.c compiler.h config.h insnsi.h nasm.h \
 nasmlib.h outform.h regs.h stdscan.h version.h
output/outrdf.o: output/outrdf.c compiler.h config.h insnsi.h nasm.h \
 nasmlib.h outform.h regs.h version.h
output/outrdf2.o: output/outrdf2.c compiler.h config.h insnsi.h nasm.h \
 nasmlib.h outform.h rdoff/rdoff.h regs.h version.h
parser.o: parser.c compiler.h config.h float.h insns.h insnsi.h nasm.h \
 nasmlib.h parser.h regflags.c regs.h stdscan.h tokens.h version.h
pptok.o: pptok.c compiler.h config.h hashtbl.h nasmlib.h pptok.h preproc.h
preproc.o: preproc.c compiler.h config.h hashtbl.h insnsi.h macros.c nasm.h \
 nasmlib.h pptok.h preproc.h regs.h stdscan.h tokens.h version.h
regdis.o: regdis.c
regflags.o: regflags.c
regs.o: regs.c compiler.h config.h
regvals.o: regvals.c
stdscan.o: stdscan.c compiler.h config.h insns.h insnsi.h nasm.h nasmlib.h \
 regs.h stdscan.h tokens.h version.h
sync.o: sync.c compiler.h config.h nasmlib.h sync.h
tokhash.o: tokhash.c compiler.h config.h hashtbl.h insns.h insnsi.h nasm.h \
 nasmlib.h regs.h tokens.h version.h
