#ifndef _NAP_WINIO_H
#define _NAP_WINIO_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include "cmds.h"

#define MAIN_SCREEN 0
#define RESULT_SCREEN 1

struct colortab_s 
{
  const char *in;
  int pair, c;
};
typedef struct colortab_s colortab_t;

struct cmds_s 
{
  char *cmd;
  struct cmds_s *prev;
  struct cmds_s *next;
};
typedef struct cmds_s cmds_t;

/* a "scroll list" entry (i.e., a line in the main srcoll) */
struct scroll_s
{
  char *line;             /* the line, null terminated. Each line is
			     self-contained even if it is a
			     continuation. I.e., it must contain its
			     own color and font control sequences. */
  int lastlog;            /* Is this line output from /lastlog? If yes, 
			     do not match it with /lastlog again. */
  chans_t *chan;          /* current channel at this line (not used) */
  struct scroll_s *own;   /* if this line is a continuation, point to
			     the physical line where this logical line
			     starts. Else NULL. This is used to indent
			     follow-up lines, and to display logical
			     (not physical) lines in the /lastlog
			     command. */
  struct scroll_s *prev;  /* doubly linked */
  struct scroll_s *next;  /* doubly linked */
};
typedef struct scroll_s scroll_t;

#ifndef MCURSES
void resize(void);
#endif

int switchtoscreen(int n);
void mainscr(void);
void wstats(WINDOW *);
void drw(WINDOW *);
void dstatus(void);
void addlog(char *logfile, char *str, int rp);
int wp(WINDOW *, const char *, ...);
void addscroll(WINDOW *, char *);
void clearscroll(void);
void scrollbottom(void);
void dscr(WINDOW *);
void dscroll(WINDOW *, int);
int doesc(WINDOW *, const char *);
int cmdcnt(cmds_t *);
cmds_t *cmdend(cmds_t *);
int input(WINDOW *, sock_t *);
void initwin(unsigned char);
void indraw(void);
unsigned char gchr(WINDOW *);

#endif /* not _NAP_WINIO_H */
