#ifndef _NAP_SCMDS_H
#define _NAP_SCMDS_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <sys/time.h>
#include <netinet/in.h>
#include "scheck.h"

struct in_nap_cmd_s 
{
  unsigned short op;
  int (*func)(int, char *, char **, int, WINDOW *);
};
typedef struct in_nap_cmd_s in_nap_cmd_t;

#define ICMP_ECHO 8
struct icmphdr 
{
  unsigned char type, code;
  unsigned short checksum;
  union
  {
    struct
    {
      unsigned short id, sequence;
    } echo;
    unsigned long gateway;
    struct
    {
      unsigned short blah, mtu;
    } frag;
  } un;
};

int in_cksum(u_short *, int);
void tvsub(register struct timeval *, register struct timeval *);
int icmpin(WINDOW *, struct sock_s *);
int icmperr(WINDOW *, struct sock_s *);
char **form_toks(char *, int *);
char **form_tokso(char *, int *);
int parsein(int, unsigned short, char *, WINDOW *);
void timed_pingresults(void *dummy);
void showresults(WINDOW *win, int havepings);

#define I_NAP_FUNC(x) int (x)(int s, char *str, char **tok, int num, WINDOW *win)

I_NAP_FUNC(sjoin);
I_NAP_FUNC(spart);
I_NAP_FUNC(stopic);
I_NAP_FUNC(ssay);
I_NAP_FUNC(snchan);
I_NAP_FUNC(sjchan);
I_NAP_FUNC(nothing);
I_NAP_FUNC(snotice);
I_NAP_FUNC(sscount);
I_NAP_FUNC(stell);
I_NAP_FUNC(suser);
I_NAP_FUNC(swhois);
I_NAP_FUNC(soff);
I_NAP_FUNC(sget);
I_NAP_FUNC(snget);
I_NAP_FUNC(snacc);
I_NAP_FUNC(sqlimit);
I_NAP_FUNC(sfreq);
I_NAP_FUNC(sry);
I_NAP_FUNC(ssf);
I_NAP_FUNC(smpart);
I_NAP_FUNC(suon);
I_NAP_FUNC(suoff);
I_NAP_FUNC(ssret);
I_NAP_FUNC(ssend);
I_NAP_FUNC(srbrowse);
I_NAP_FUNC(sdbrowse);
I_NAP_FUNC(sbrowse2acc);
I_NAP_FUNC(sbrowse2err);
I_NAP_FUNC(sbrowse2req);
I_NAP_FUNC(sop);
I_NAP_FUNC(spchange);
I_NAP_FUNC(sbport);
I_NAP_FUNC(sannounce);
I_NAP_FUNC(sbanlist);
I_NAP_FUNC(scping);
I_NAP_FUNC(scpong);
I_NAP_FUNC(ssping);
I_NAP_FUNC(sredir);
I_NAP_FUNC(scycle);
I_NAP_FUNC(sclist);
I_NAP_FUNC(sclist2);
I_NAP_FUNC(snend);
I_NAP_FUNC(sblocklist);
I_NAP_FUNC(signorelist);
I_NAP_FUNC(signoreend);
I_NAP_FUNC(signoreadd);
I_NAP_FUNC(signoreremove);
I_NAP_FUNC(signoreunknown);
I_NAP_FUNC(signoreexists);
I_NAP_FUNC(signoreclear);
I_NAP_FUNC(signorefail);
I_NAP_FUNC(scbanlist);
I_NAP_FUNC(snerr);
I_NAP_FUNC(snadd);
I_NAP_FUNC(sme);

#endif  /* _NAP_SCMDS_H */

