#ifndef _NAP_SCHECK_H
#define _NAP_SCHECK_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <ncurses.h>
#include "cmds.h"  
                   
/* used to mark a sock_t connection as "read" or "write". Note: a
   read/write connection can be marked S_R if we are waiting for the
   other end to talk to us first (such as the server connection). S_W
   is currently only used for uploads. */

#define S_R 0x1
#define S_W 0x2

/* The connection list is one of the two "backbone" data structures of
   nap (the other is the task list, of type file_t, see cmds.h). */

struct sock_s 
{
  int fd;                   /* file descriptor of this connection */
  unsigned char t;          /* S_R or S_W: wait for incoming/outgoing? */
  char *nm;                 /* name of this connection, e.g. "server" */
  struct download_s *dtask; /* only used for download connections */
  struct upload_s *utask;   /* only used for upload connections */
  char *dxx;                /* only used for irc connections */
  int (*func)(WINDOW *, struct sock_s *);  /* event handler, e.g. in event.c */
  struct sock_s *next; 
};
typedef struct sock_s sock_t;

sock_t *addsock(int, char *, unsigned char, int (*)(WINDOW *, sock_t *));
void delsock(int);
sock_t *findsock(const char *);
sock_t *findsockfd(int fd);
void psocks(WINDOW *);
void sockfunc(WINDOW *, WINDOW *);

#endif

