#ifndef _NAP_NAP_H
#define _NAP_NAP_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#include <dirent.h>
#include <sys/stat.h>
#include <unistd.h>
#include <netinet/in.h>
#include "sscr.h"

extern int cloaked;  /* whether we are cloaked */

struct phead_s 
{
  unsigned short len;
  unsigned short op;
};
typedef struct phead_s phead_t;

/* the info structure contains certain global values that are set on
   the command line, prompted from the user, or read from the
   configuration file at startup. Some of these values can later be updated
   with user commands. */

struct info_s 
{
  char *user;            /* our Napster login name */
  char *pass;            /* our Napster password */
  char *email;           /* our Napster email address */
  char *up;              /* list of upload directories, separated by ";" */
  char *down;            /* a single download directory */
  char *incomplete;      /* a directory to hold incomplete files */
  char *serverlist;      /* ';'-separated list of servers to connect to */
  char *logallfile;      /* name of general log file (or NULL) */
  char *logfile;         /* name of transfer log file (or NULL) */
  char *maxuploads;      /* max number of simultaneous uploads - an integer */
  char *conn;            /* connection speed 0-9 */
  char *d;               /* debug level - an integer */
  char *dataport;        /* port or range of ports to use for client-to-client
			    connections */
  int autorestart;       /* auto reconnect when connection to server lost? */

  int port;              /* the actual dataport we are currently using
                            - not really a command line option, but a
                            state variable */

  char *shared_filename; /* name of shared library file */
  int daemon;            /* if !=0, run without user interface. When 1,
			    output to stdout, when 2, suppress output */
  int nxterm;            /* option --nxterm */
  int build;             /* 0=don't build, 1=build library, 2=build and exit */
  int create;            /* create new account? This is reset to 0 after acct created */
  int reconnect;         /* keep reconnecting until connection established? */
  int notop;             /* if set, display no title */
};
typedef struct info_s info_t;

/* structure to hold a pair of a device and an inode. This information
   suffices to uniquely identify a file or directory on a machine,
   even across different file systems */

struct dev_inode_s {
  dev_t dev;
  ino_t ino;
  struct dev_inode_s *next;
};
typedef struct dev_inode_s dev_inode_t;

void doquit(void);
void tresize(int);
void sigint(int);
void noop(int);
void dochecks(void);
char *quote(char *s);
char *home_file(const char *fn);
char *itoa(int n);
char *strip(char *);
char *getline(FILE *f);
int readcfg(char *);
int msprintf(char **, const char *, ...);
int vmsprintf(char **str, const char *fmt, va_list args);
int strcnt(char *, char);
void phelp(char *);
void dopts(int, char **);
int setup_configdir(void);
int move_file(const char *oldpath, const char *newpath);
char *next_server(char *serverlist);
int main(int argc, char *argv[]);

int rebuild(int, char *, char *);
int isshared(char *fn, char *sd);
int buildflist(char *, char *);
void dir(char *, FILE *);
void ddir(char *, DIR *, FILE *);
int lfiles(int, char *);
int up_to_date(char *sd, char *path);
int modified_after(time_t mtime, char *fn, dev_inode_t **di_list_p);

int resolve(const char *host, struct in_addr *inp);
const char *getpeerip(int fd);
unsigned long int swapl(unsigned long int x);
int connect_t(int fd, struct sockaddr *serv_addr, int addlen, int t);
int conn(char *, unsigned short);
int login(int, char *, char *, int, char *, int, char *);
int makeact(int, char *, char *, int, char *, int, char *);
char *glistn(char *);
void checkhotlist(int, char *);
int checknv(int fd, int timeout, const char **errmsg);

int savechans(chans_t *cl, char *fn);
int loadchans(int s, char *fn);
chans_t *findchan(chans_t *, char *);
chans_t *findquery(chans_t *, char *);

int sendpack(int, int, const char *, ...);
int ssock(int, const char *, ...);
int recvpack(int, char **, phead_t **);
int rsock(int, char **);

#endif /* not _NAP_NAP_H */
