#ifndef _NAP_NAP_H
#define _NAP_HAP_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */


#include <dirent.h>
#include "sscr.h"


struct phead_s 
{
  unsigned short len;
  unsigned short op;
};
typedef struct phead_s phead_t;


struct info_s 
{
  char *user, *pass;
  char *up, *down;
  char *email;
  int port, conn;
  unsigned char d, cloak;
  FILE *log, *xfer;
};
typedef struct info_s info_t;


struct cmds_s 
{
  unsigned char cmd[512];
  struct cmds_s *prev;
  struct cmds_s *next;
};
typedef struct cmds_s cmds_t;


void ctrlc(int);
void doquit(void);
void tresize(int);
void sigint(int);
void dochecks(void);

#ifndef MCURSES
void resize(void);
#endif

void wstats(WINDOW *);
void drw(WINDOW *);
void dstatus();
int readcfg(char *);
void checkhotlist(int, char *);
int isshared(char *);
char *findent(FILE *, char *);
int msprintf(char **, char *, ...);
int strcnt(char *, char);
void addlog(FILE *, char *, unsigned char);
int wp(WINDOW *, char *, ...);
scrls_t *scrend(scrls_t *);
void addscroll(WINDOW *, char *);
void dscr(WINDOW *);
void dscroll(WINDOW *, int);
int doesc(WINDOW *, char *);
int cmdcnt(cmds_t *);
cmds_t *cmdend(cmds_t *);
void phelp(char *);
void dopts(int, char **, char **, char **, int *, int *, int *, int *);
char *glistn(char *);
void savechans(chans_t *);
void loadchans(int);
void initssock(int);
int inssock(WINDOW *, sock_t *);
void checknv(char *, int, char *);
int rebuild(int, char *, char *);
int buildflist(char *, char *);
void dir(char *, FILE *);
void ddir(char *, DIR *, FILE *);
int lfiles(int, char *);
long resolve(char *);
int conn(char *, unsigned short);
int login(int, char *, char *, int, char *, int, char *);
int makeact(int, char *, char *, int, char *, int, char *);
void initwin(unsigned char);
int inipc(WINDOW *, sock_t *);
int inserv(WINDOW *, sock_t *);
unsigned char gchr(WINDOW *);
int input(WINDOW *, sock_t *);
chans_t *findchan(chans_t *, char *);
chans_t *findquery(chans_t *, char *);
int sendpack(int, unsigned short, char *, ...);
int ssock(int, char *, ...);
int recvpack(int, char **, phead_t **);
int rsock(int, char **);
void indraw(char *, int, WINDOW *);
char *fxp(char *);
int gconn(WINDOW *, sock_t *);
int lsock(WINDOW *, sock_t *);
int doget(WINDOW *, sock_t *);
int dosend(WINDOW *, sock_t *);
int initfserve(int);
void closefserv(void);
int initsend(WINDOW *, sock_t *);
int ssize(WINDOW *, sock_t *);
int initget(WINDOW *, sock_t *);
int gsize(WINDOW *, sock_t *);
int sfile(WINDOW *, sock_t *);
int gfile(WINDOW *, sock_t *);

#endif
