#ifndef _NAP_IRC_H
#define _NAP_IRC_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

struct in_irc_cmd_s 
{
  char *text;
  int (*func)(int, char *, char **, int, WINDOW *);
};
typedef struct in_irc_cmd_s in_irc_cmd_t;

struct out_irc_cmd_s 
{
  char *text;
  void (*func)(int, char *, char **, int, WINDOW *);
};
typedef struct out_irc_cmd_s out_irc_cmd_t;


#define I_IRC_FUNC(x) int (x)(int s, char *str, char **tok, int num, WINDOW *win)

I_IRC_FUNC(hping);
I_IRC_FUNC(h433);
I_IRC_FUNC(h372);
I_IRC_FUNC(h353);
I_IRC_FUNC(h332);
I_IRC_FUNC(h333);
I_IRC_FUNC(hjoin);
I_IRC_FUNC(hpart);
I_IRC_FUNC(htopic);
I_IRC_FUNC(h311);
I_IRC_FUNC(h319);
I_IRC_FUNC(h312);
I_IRC_FUNC(h367);
I_IRC_FUNC(hnick);
I_IRC_FUNC(hquit);
I_IRC_FUNC(hmode);
I_IRC_FUNC(hkick);
I_IRC_FUNC(hprivmsg);
I_IRC_FUNC(hnotice);
I_IRC_FUNC(h376);
I_IRC_FUNC(h352);
I_IRC_FUNC(h315);
I_IRC_FUNC(h324);
I_IRC_FUNC(h341);
I_IRC_FUNC(h314);
I_IRC_FUNC(hinvite);
I_IRC_FUNC(herr);
I_IRC_FUNC(herr2);
I_IRC_FUNC(h317);
I_IRC_FUNC(h313);

#define O_IRC_FUNC(x) void (x)(int s, char *str, char **tok, int num, WINDOW *win)

O_IRC_FUNC(imsg);
O_IRC_FUNC(iquit);
O_IRC_FUNC(ikick);
O_IRC_FUNC(ime);
O_IRC_FUNC(inotice);
O_IRC_FUNC(inick);
O_IRC_FUNC(iirc);
O_IRC_FUNC(iwhois);
O_IRC_FUNC(itopic);
O_IRC_FUNC(ipart);
O_IRC_FUNC(iaddr);
O_IRC_FUNC(iban);
O_IRC_FUNC(inap);
O_IRC_FUNC(ictcp);
O_IRC_FUNC(iinvite);
O_IRC_FUNC(iopsay);
O_IRC_FUNC(idcc);
O_IRC_FUNC(ichat);


int dccfunc(WINDOW *, sock_t *);
int ldcc(WINDOW *, sock_t *);
int inirc(WINDOW *, sock_t *);
char *gnick(char *);
void delircchans(void);
void delnapchans(void);
int checkouts(int s, char *, char **, int, WINDOW *);

#endif
