#ifndef _NAP_MP3S_H
#define _NAP_MP3S_H

/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

/* Physical layout of mp3 header. Note: to ensure portability, we no
   longer read binary data directly into this struct. -PS */
struct hdr_s 
{
  unsigned int
  emph:2,
  original:1,
  copyright:1,
  mode_ext:2,
  mode:2,
  pvt:1,
  pad:1,
  freq:2,
  brate:4,
  prot:1,
  layer:2,
  id:1,
  sync:12;
};
typedef struct hdr_s hdr_t;

/* physical layout of id3v2 header. Note that all fields in this
   struct are byte-sized; thus it should be safe (with respect to
   portability) to read binary data directly into it. */
struct id3v2_s 
{
  unsigned char id[3];
  unsigned char ver, revis;
  unsigned char flags;
  unsigned char size[4];
};
typedef struct id3v2_s id3v2_t;

/* mhdr_s holds various information about an mp3. This information is
   collected to be stored in the library file. Note the following
   quirk about MD5 checksums: the official napster clients use a
   string of the form

   d1534c6a8787f6769a90c87f6s78b45c-5823419

   where the first 32 characters are the MD5 hash in hex, and the part
   after the dash is the size. But this is not the actual *file* size;
   rather it is the size of the mp3 data, i.e., the file size minus
   the size of any tags (such as id3 tags or the 128-byte tags which
   frequently appear at the end of an mp3 file). Nap previously just
   used the file size, which is not what the official clients do.
   Thus, we have a sz1 field in the mhdr_s structure to hold this
   alternative size. 
*/

struct mhdr_s 
{
  unsigned int bitrate;    /* in 1000 bits/sec (or 1024 bits/sec?) */
  unsigned int freq;       /* sample frequency */
  unsigned int len;        /* length in seconds */
  size_t sz;               /* size in bytes */
  char check[33];          /* md5 hash (checksum) */
  size_t sz1;              /* size for the purpose of checksum, need not
			      equal sz */
};
typedef struct mhdr_s mhdr_t;


int checkhdr(hdr_t *);
hdr_t *getrhdr(int);
mhdr_t *gethdr(char *, int);
int md5_stream_blocks (int fd, int kb, void *resblock);

#endif
