/* Copyright (c) 2000  Kevin Sullivan <nite@gis.net>
 *
 * Please refer to the COPYRIGHT file for more information.
 */

#define USE_COLORS

#ifdef __CYGWIN32__
/* Note: this is not needed any more - use <select.h> timeval, not 
   <time.h> timespec. -PS */
  /*
  struct timespec
  {
    long int tv_sec;
    long int tv_nsec;
  }; 
  */
  
  #define setbuffer(s, b, t) setvbuf(s,  b,  b  ?  _IOFBF   :   _IONBF, t)
  
  #define	timerisset(tvp)		((tvp)->tv_sec || (tvp)->tv_usec)
  #define	timerclear(tvp)		((tvp)->tv_sec = (tvp)->tv_usec = 0)
#endif


typedef int (*ucmd_func_t)();

/* some static limits */
#define MAXCHANS 5
#define TABSIZE 5
#define BACKLOG 32

/* incomplete files of this size or less are considered "turds" and
   will be removed. This is the default value; the actual value can be
   overridden by the turdsize user variable. */
#define TURDSIZE 100000

/* the default port for napster servers */
#define PORT 8875

/* where to get news about new versions of this client */
#define CLIENTNEWSHOST "theory.stanford.edu"
#define CLIENTNEWSPORT 80
#define CLIENTNEWSFILE "/~selinger/nap/UPDATE"

/* the client name which we send to the server on login. It may be
   necessary to lie here, as certain OpenNap servers have been known
   to be nasty to nap ("bad client"). Add command line option "--lie"
   in the future? */
#define CLIENT VERSION

/* some file names for standard files. These are in the user's home
   directory, unless noted otherwise. */

#define CONFIGFILE  ".napconf"
#define LIBRARYFILE ".nap_shared"
#define HOTLISTFILE ".nap_hotlist_%s"  /* %s is user name in lower case */
#define ALIASFILE   ".nap_aliases"
#define HANDLERFILE ".nap_handlers"
#define CHANNELFILE ".nap_channels_%s" /* %s is user name *not* lower cased */

#ifdef USERCMDS
  #define USERLIB   "./cmdslib.so"     /* in current working directory */
#endif

/* library file header, must change when the file format changes */
#define NAP_LIBRARY_HEADER \
  "NAP LIBRARY FILE v01. Automatically generated file, do not edit."

/* markers that are used to add checksum tags to incomplete files */
#define INCTAG_START "<NAP incomplete file checksum "
#define INCTAG_END   " incomplete file checksum NAP>"

#ifndef MCURSES
  #define newwin(n, l, c, y, x) (newwin(l, c, y, x))
#endif

