/*
 * Copyright (c) 1997 University of Southern California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Information Sciences
 *      Institute of the University of Southern California.
 * 4. Neither the name of the University nor of the Institute may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * @(#) $Header: /usr/src/mash/repository/vint/nam-1/agent.h,v 1.7 1999/12/11 06:56:56 hyunahpa Exp $ (LBL)
 */

#ifndef nam_agent_h
#define nam_agent_h

class Queue;
class Edge;
class Feature;
class Node;
class NetView;
class PSView;
class Monitor;

#include "animation.h"

class Agent : public Animation {
    public:
	virtual int classid() const { return ClassAgentID; }
	inline const char* name() const { return (label_); }
	inline int num() const { return (nn_); }
	inline double size() const { return (size_); }
	virtual void size(double s);
	virtual void reset(double);
	inline double x() const { return (x_); }
	inline double y() const { return (y_); }
	virtual void place(double x, double y);
	void label(const char* name, int anchor);
	inline int anchor() const { return (anchor_); }
	inline void anchor(int v) { anchor_ = v; }
	inline Agent *next() const { return next_;}
	inline void next(Agent *a) { next_=a;}
	inline Edge *edge() const { return edge_;}
	inline double angle() const { return angle_;}
	inline void angle(double a) { angle_=a;}
	virtual float distance(float x, float y) const;

	void add_feature(Feature *f);
	Feature *find_feature(char *) const;
	void delete_feature(Feature *f);
	const char* info() const;
	const char* getname() const;
	void monitor(Monitor *m, double now, char *result, int len);
	inline int marked() const { return (mark_); }
	inline void mark(int v) { mark_ = v; }
	virtual void update_bb();

        int Agent::saveAsNs(FILE *file);
        //      int Agent::saveAsEnam(FILE *file);

	Agent* next_;
	Node* node_;
    protected:
	Agent(const char* name, double size);
	void drawlabel(View*) const;
	void drawlabel(PSView*) const;

	double size_;
	double width_;
	double height_;
	double x_, y_;
	Feature* features_;
	Edge* edge_;
	double angle_;
	int anchor_;
	int mark_;
	char* label_;
	int nn_;
};

class BoxAgent : public Agent {
 public:
	BoxAgent(const char* name, double size);
	virtual void size(double s);
	virtual void draw(View*, double now) const;
	virtual void draw(PSView*, double now) const;
	virtual void place(double x, double y);
	int inside(double, float, float) const;
	virtual void update_bb();
 private:
	float x0_, y0_;
	float x1_, y1_;
};

#endif
