<?php
/*
 * $Horde: nag/task.php,v 1.21.2.3 2002/05/26 17:44:00 jan Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';

/* Redirect to the task list if no action has been requested. */
$actionID = Horde::getFormData('actionID', NOOP);
if ($actionID === NOOP) {
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

/* Create a Nag storage instance. */
require_once NAG_BASE . '/lib/Driver.php';
$storage = &Nag_Driver::factory($conf['storage']['driver'], Auth::getAuth(),
                                $conf['storage']['params']);
$storage->retrieve();

/* Retrieve the task list. */
$tasks = Nag::listTasks($storage);

/* Run through the action handlers. */
switch($actionID) {
case NAG_ADD_TASK:

    /* Set up the task attributes. */
    $task_id = null;
    $task_name = '';
    $task_due = 0;
    $task_desc = '';
    $task_priority = 3;
    $task_completed = 0;
    $task_category = 0;

    /* Set the initial due date to one week from now. */
    $initial_date = time() + 604800;
    $javascript = 'onchange="document.task.due_type[0].checked = true;"';
    $day_widget = Nag::buildDayWidget('due_day', $initial_date, $javascript);
    $month_widget = Nag::buildMonthWidget('due_month', $initial_date, $javascript);
    $year_widget = Nag::buildYearWidget('due_year', 3, $initial_date, $javascript);
    $hour_widget = Nag::buildHourWidget('due_hour', $initial_date, $javascript);
    $minute_widget = Nag::buildMinuteWidget('due_minute', 15, null, $javascript);

    /* Set up the radio buttons. */
    $none_checked = ($task_due == 0) ? 'checked="checked" ' : '';
    $specified_checked = ($task_due != 0) ? 'checked="checked" ' : '';

    $title = _("Adding A New Task");

    break;

case NAG_MODIFY_TASK:

    $task_id = Horde::getFormData('task');

    if (isset($task_id) && isset($tasks[$task_id])) {
        /* Set up the task attributes. */
        $task_name = $tasks[$task_id]['name'];
        $task_due = $tasks[$task_id]['due'];
        $task_desc = $tasks[$task_id]['desc'];
        $task_priority = $tasks[$task_id]['priority'];
        $task_completed = $tasks[$task_id]['completed'];
        $task_category = $tasks[$task_id]['category'];

        /* If the due date isn't set, set the widgets to the default. */
        $due_date = ($task_due > 0) ? $task_due : (time() + 604800);
        $javascript = 'onchange="document.task.due_type[1].checked = true;"';

        /* Set up the due date selection widgets. */
        $day_widget = Nag::buildDayWidget('due_day', $due_date, $javascript);
        $month_widget = Nag::buildMonthWidget('due_month', $due_date, $javascript);
        $year_widget = Nag::buildYearWidget('due_year', 3, $due_date, $javascript);
        $hour_widget = Nag::buildHourWidget('due_hour', $due_date, $javascript);
        $minute_widget = Nag::buildMinuteWidget('due_minute', 15, $due_date, $javascript);

        /* Set up the radio buttons. */
        $none_checked = ($task_due == 0) ? 'checked="checked" ' : '';
        $specified_checked = ($task_due > 0) ? 'checked="checked" ' : '';

        $title = _("Modifying:") . ' ' . $task_name;
    } else {
        $title = _("Unknown task");
    }

    break;

case NAG_SAVE_TASK:

    /* Get the form values. */
    $task_id = Horde::getFormData('task');
    $task_name = Horde::getFormData('task_name');
    $task_desc = Horde::getFormData('task_desc');
    $task_priority = Horde::getFormData('task_priority');
    $task_completed = Horde::getFormData('task_completed');
    $task_category = Horde::getFormData('task_category');
    $due_type = Horde::getFormData('due_type');
    $due_day = Horde::getFormData('due_day');
    $due_month = Horde::getFormData('due_month');
    $due_year = Horde::getFormData('due_year');
    $due_hour = Horde::getFormData('due_hour');
    $due_minute = Horde::getFormData('due_minute');

    /* Convert the due date to Unix time. */
    $due_str = "$due_month/$due_day/$due_year $due_hour:$due_minute";

    /* Set the due date according to the $due_type toggle. */
    $task_due = (strcasecmp($due_type, 'none')) ? strtotime($due_str) : 0;

    /*
     * If $task_id is set, we're modifying an existing task.  Otherwise,
     * we're adding a new task with the provided attributes.
     */
    if (isset($task_id) && isset($tasks[$task_id])) {
        $storage->modifyTask($task_id, 'name', $task_name);
        $storage->modifyTask($task_id, 'desc', $task_desc);
        $storage->modifyTask($task_id, 'due', $task_due);
        $storage->modifyTask($task_id, 'priority', $task_priority);
        $storage->modifyTask($task_id, 'completed', $task_completed);
        $storage->modifyTask($task_id, 'category', $task_category);
    } else {
        $task_id = $storage->addTask($task_name, $task_desc, $task_due,
                                     $task_priority, $task_completed,
                                     $task_category);
    }

    /* Store the changes. */
    if (PEAR::isError($storage->store())) {
        $notification->push(_("There was a problem saving the task."), 'horde.error');
    }

    /* Return to the task list. */
    header('Location: ' . Horde::applicationUrl("view.php?task=$task_id", true));
    exit;

    break;

case NAG_DELETE_TASKS:

    /* Delete the task if we're provided with a valid task ID to delete. */
    $task_id = Horde::getFormData('task');
    if (isset($task_id) && isset($tasks[$task_id])) {
        if ($storage->deleteTask($task_id)) {
            if (!PEAR::isError($storage->store())) {
                $notification->push(_("Deleted 1 task."), 'horde.success');
            } else {
                $notification->push(_("There was a problem deleting tasks."), 'horde.error');
            }
        }
    }

    /* Return to the task list. */
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;

    break;

default:
    header('Location: ' . Horde::applicationUrl('list.php', true));
    exit;
}

$js_onLoad = null;
require NAG_TEMPLATES . '/common-header.inc';
require NAG_BASE . '/menu.php';
$notification->notify();
require NAG_TEMPLATES . '/task/begin.inc';
require NAG_TEMPLATES . '/task/task.inc';
require NAG_TEMPLATES . '/task/end.inc';
require NAG_TEMPLATES . '/common-footer.inc';

$prefs->store();

?>
