<?php
/*
 * $Horde: nag/prefs.php,v 1.14.2.3 2002/04/23 06:25:16 chuck Exp $
 *
 * Copyright 2001 Jon Parise <jon@horde.org>
 *
 * See the enclosed file COPYING for license information (GPL).  If you
 * did not receive this file, see http://www.fsf.org/copyleft/gpl.html.
 */

/**
 * Call PrefsUI::groupIsEditable() here because we can rely on it being present
 * in Horde 2.1 but the prefs template still calls groupIsEditable().
 */
function groupIsEditable($group)
{
    return PrefsUI::groupIsEditable($group);
}


define('NAG_BASE', dirname(__FILE__));
require_once NAG_BASE . '/lib/base.php';
require_once HORDE_BASE . '/lib/PrefsUI.php';
require NAG_BASE . '/config/prefs.php';

/* See if we have a preferences group set. */
$group = Horde::getFormData('group');
$js_onLoad = null;

if (PrefsUI::handleForm($group)) {
    $group = null;
    include NAG_BASE . '/config/prefs.php';
}

$title = _("User Options");
require NAG_TEMPLATES . '/common-header.inc';
require NAG_BASE . '/menu.php';
$notification->notify();

PrefsUI::generateUI($group);

$registry->shutdown();
require NAG_TEMPLATES . '/common-footer.inc';

?>
