<?php
// $Horde: nag/lib/api.php,v 1.12.2.3 2002/05/27 12:01:19 jan Exp $
/*
 * Nag external API interface.
 *
 * This file defines Nag's external API interface.  Other applications can
 * interact with Nag through this API.
 */

// Find the base file paths for Horde and Nag
@define('NAG_BASE', dirname(__FILE__) . '/..');

// Include the necessary libraries.
require_once NAG_BASE . '/lib/base.php';

function nagListTasks($sortby = null, $sortdir = null)
{
    global $conf, $prefs;

    if (!isset($sortby)) $sortby = $prefs->getValue('sortby');
    if (!isset($sortdir)) $sortdir = $prefs->getValue('sortdir');

    /* Create a Nag storage instance. */
    require_once NAG_BASE . '/lib/Driver.php';
    $storage = &Nag_Driver::singleton($conf['storage']['driver'],
                                      Auth::getAuth(), $conf['storage']['params']);
    $storage->retrieve();

    return Nag::listTasks($storage, $sortby, $sortdir);
}

function nagAddTask($name = '', $description = '', $due = 0)
{
    global $conf;

    /* Create a Nag_Driver instance. */
    require_once NAG_BASE . '/lib/Driver.php';
    $storage = &Nag_Driver::singleton($conf['storage']['driver'],
                                      Auth::getAuth(), $conf['storage']['params']);
    $storage->retrieve();

    /* Add the new task. */
    $result = $storage->addTask($name, $description, $due);
    if ($result >= 0) {
        $result = $storage->store();
    }

    return $result;
}

function nagSummary()
{
    global $registry;

    $html  = '<table border="0" cellpadding="2" cellspacing="0" width="100%"><tr><td class="header">';
    $html .= Horde::link(Horde::url($registry->getInitialPage()), $registry->getParam('name'), 'header') . $registry->getParam('name') . '</a> - ';
    $html .= Horde::link(Horde::applicationUrl('task.php?actionID=' . NAG_ADD_TASK), _("New Task"), 'smallheader') . Horde::img('note.gif', 'alt="' . _("New Task") . '"') . _("New Task") . '</a>';

    $html .= '</td></tr><tr><td class="text"><table border="0" cellpadding="0" cellspacing="0">';

    $tasks = nagListTasks();
    foreach ($tasks as $id => $task) {
        $html .= '<tr><td class="text">';
        $row = Horde::link(Horde::applicationUrl('view.php?task=' . $id), $task['name']) . htmlspecialchars($task['name']) . '</a>';
        if (!empty($task['due']) && $task['due'] < mktime()) {
            $html .= '<b>';
        }
        if (!empty($task['due'])) {
            $row .= ' (' . strftime('%c', $task['due']) . ')';
        }
        if (!empty($task['due']) && $task['due'] < mktime()) {
            $html .= '<font color="red">' . $row . '</font></b>';
        } else {
            $html .= $row;
        }
        $html .= "</td></tr>\n";
    }
    $html .= '</table></td></tr></table>';

    return $html;
}

?>
