/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbcext.translators.ArrayTranslator;
import com.sap.dbtech.jdbcext.translators.AsciiStreamTranslator;
import com.sap.dbtech.jdbcext.translators.BigDecimalTranslator;
import com.sap.dbtech.jdbcext.translators.BinaryStreamTranslator;
import com.sap.dbtech.jdbcext.translators.BlobTranslator;
import com.sap.dbtech.jdbcext.translators.BooleanTranslator;
import com.sap.dbtech.jdbcext.translators.ByteTranslator;
import com.sap.dbtech.jdbcext.translators.BytesTranslator;
import com.sap.dbtech.jdbcext.translators.CharacterStreamTranslator;
import com.sap.dbtech.jdbcext.translators.ClobTranslator;
import com.sap.dbtech.jdbcext.translators.DateTranslator;
import com.sap.dbtech.jdbcext.translators.DoubleTranslator;
import com.sap.dbtech.jdbcext.translators.FloatTranslator;
import com.sap.dbtech.jdbcext.translators.IntTranslator;
import com.sap.dbtech.jdbcext.translators.LongTranslator;
import com.sap.dbtech.jdbcext.translators.NullTranslator;
import com.sap.dbtech.jdbcext.translators.ObjectTranslator;
import com.sap.dbtech.jdbcext.translators.RefTranslator;
import com.sap.dbtech.jdbcext.translators.ShortTranslator;
import com.sap.dbtech.jdbcext.translators.StringTranslator;
import com.sap.dbtech.jdbcext.translators.TimeTranslator;
import com.sap.dbtech.jdbcext.translators.TimestampTranslator;
import com.sap.dbtech.jdbcext.translators.UnicodeStreamTranslator;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Map;
import java.util.Vector;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;

public abstract class AbstractRowSetSapDB
implements Serializable,
Cloneable {
    protected String command = null;
    protected String URL = null;
    protected String dataSource = null;
    protected transient String username = null;
    protected transient String password = null;
    protected int rowSetType = 1005;
    protected boolean showDeleted = false;
    protected int queryTimeout = 0;
    protected int maxRows = 0;
    protected int maxFieldSize = 0;
    protected int concurrency = 1007;
    protected boolean readOnly = true;
    protected boolean escapeProcessing = true;
    protected int isolation = 2;
    protected int fetchDir = 1000;
    protected int fetchSize = 30000;
    protected Map map = null;
    protected ArrayList listeners = new ArrayList();
    protected Vector params = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRowSetListener(RowSetListener rowSetListener) {
        if (rowSetListener == null) {
            return;
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                if (this.listeners.get(i) != rowSetListener) continue;
                return;
            }
            this.listeners.add(rowSetListener);
        }
    }

    public void clearParameters() throws SQLException {
        this.params.clear();
    }

    public String getCommand() {
        return this.command;
    }

    public int getConcurrency() throws SQLException {
        return this.concurrency;
    }

    public String getDataSourceName() {
        return this.dataSource;
    }

    public boolean getEscapeProcessing() throws SQLException {
        return this.escapeProcessing;
    }

    public int getFetchDirection() throws SQLException {
        return this.fetchDir;
    }

    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    public int getMaxFieldSize() throws SQLException {
        return this.maxFieldSize;
    }

    public int getMaxRows() throws SQLException {
        return this.maxRows;
    }

    public Object[] getParams() throws SQLException {
        return this.params.toArray();
    }

    public String getPassword() {
        return this.password;
    }

    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    public boolean getShowDeleted() throws SQLException {
        return this.showDeleted;
    }

    public int getTransactionIsolation() {
        return this.isolation;
    }

    public int getType() throws SQLException {
        return this.rowSetType;
    }

    public Map getTypeMap() {
        return this.map;
    }

    public String getUrl() throws SQLException {
        return this.URL;
    }

    public String getUsername() {
        return this.username;
    }

    protected void initParams() {
        this.params = new Vector();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyCursorMoved() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                int n = this.listeners.size();
                for (int i = 0; i < n; ++i) {
                    RowSetListener rowSetListener = (RowSetListener)this.listeners.get(i);
                    rowSetListener.cursorMoved(rowSetEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRowChanged() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                int n = this.listeners.size();
                for (int i = 0; i < n; ++i) {
                    RowSetListener rowSetListener = (RowSetListener)this.listeners.get(i);
                    rowSetListener.rowChanged(rowSetEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyRowSetChanged() {
        if (!this.listeners.isEmpty()) {
            RowSetEvent rowSetEvent = new RowSetEvent((RowSet)((Object)this));
            ArrayList arrayList = this.listeners;
            synchronized (arrayList) {
                int n = this.listeners.size();
                for (int i = 0; i < n; ++i) {
                    RowSetListener rowSetListener = (RowSetListener)this.listeners.get(i);
                    rowSetListener.rowSetChanged(rowSetEvent);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRowSetListener(RowSetListener rowSetListener) {
        if (this.listeners == null) {
            return;
        }
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            int n = this.listeners.size();
            for (int i = 0; i < n; ++i) {
                if (this.listeners.get(i) != rowSetListener) continue;
                this.listeners.remove(i);
                return;
            }
        }
    }

    public void setArray(int n, Array array) throws SQLException {
        this.params.add(new ArrayTranslator(n, array));
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.params.add(new AsciiStreamTranslator(n, inputStream, n2));
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.params.add(new BigDecimalTranslator(n, bigDecimal));
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.params.add(new BinaryStreamTranslator(n, inputStream, n2));
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.params.add(new BlobTranslator(n, blob));
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.params.add(new BooleanTranslator(n, bl));
    }

    public void setByte(int n, byte by) throws SQLException {
        this.params.add(new ByteTranslator(n, by));
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.params.add(new BytesTranslator(n, byArray));
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.params.add(new CharacterStreamTranslator(n, reader, n2));
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.params.add(new ClobTranslator(n, clob));
    }

    public void setCommand(String string) throws SQLException {
        this.command = string;
        this.params.clear();
    }

    public void setConcurrency(int n) {
        this.concurrency = n;
    }

    public void setDataSourceName(String string) {
        this.dataSource = string == null ? null : new String(string);
        this.URL = null;
    }

    public void setDate(int n, Date date) throws SQLException {
        this.params.add(new DateTranslator(n, date));
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.params.add(new DateTranslator(n, date, calendar));
    }

    public void setDouble(int n, double d) throws SQLException {
        this.params.add(new DoubleTranslator(n, d));
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.escapeProcessing = bl;
    }

    public void setFetchDirection(int n) throws SQLException {
        this.fetchDir = n;
    }

    public void setFetchSize(int n) throws SQLException {
        this.fetchSize = n;
    }

    public void setFloat(int n, float f) throws SQLException {
        this.params.add(new FloatTranslator(n, f));
    }

    public void setInt(int n, int n2) throws SQLException {
        this.params.add(new IntTranslator(n, n2));
    }

    public void setLong(int n, long l) throws SQLException {
        this.params.add(new LongTranslator(n, l));
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.maxFieldSize = n;
    }

    public void setMaxRows(int n) throws SQLException {
        this.maxRows = n;
    }

    public void setNull(int n, int n2) throws SQLException {
        this.params.add(new NullTranslator(n));
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.params.add(new NullTranslator(n));
    }

    public void setObject(int n, Object object) throws SQLException {
        this.params.add(new ObjectTranslator(n, object));
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.params.add(new ObjectTranslator(n, object, n2));
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.params.add(new ObjectTranslator(n, object, n2, n3));
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.queryTimeout = n;
    }

    public void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.params.add(new RefTranslator(n, ref));
    }

    public void setShort(int n, short s) throws SQLException {
        this.params.add(new ShortTranslator(n, s));
    }

    public void setString(int n, String string) throws SQLException {
        this.params.add(new StringTranslator(n, string));
    }

    public void setTime(int n, Time time) throws SQLException {
        this.params.add(new TimeTranslator(n, time));
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.params.add(new TimeTranslator(n, time, calendar));
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.params.add(new TimestampTranslator(n, timestamp));
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.params.add(new TimestampTranslator(n, timestamp, calendar));
    }

    public void setTransactionIsolation(int n) {
        this.isolation = n;
    }

    public void setType(int n) {
        this.rowSetType = n;
    }

    public void setTypeMap(Map map) {
        this.map = map;
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.params.add(new UnicodeStreamTranslator(n, inputStream, n2));
    }

    public void setUrl(String string) throws SQLException {
        this.URL = string == null ? null : string;
        this.dataSource = null;
    }

    public void setUsername(String string) {
        this.username = new String(string);
    }
}

