//
//  MWorkbench.mm
//  MySQL Workbench
//
//  Created by Alfredo Kojima on 05/8/22.
//  Copyright 2005 MySQL AB. All rights reserved.
//

#import "MWorkbench.h"
#define ENABLE_JAVA_MODULES
#import <MySQLGRT/MGRT.h>
#import <MySQLGRT/MGRTValue.h>
#import <MySQLToolsCommon/MPreferences.h>
#include <WBCanvas/myx_gc.h>
#include <WBCanvas/myx_gc_font_manager.h>
#include <WBCanvas/myx_grt_wb_public_interface.h>
#include <MySQLGRT/myx_grt_public_interface.h>
#import "MWDocument.h"


@implementation MWorkbench

static MWorkbench *instance= 0;

- (MWorkbench*)singleton
{
  return instance;
}


- (void)awakeFromNib
{
  instance= self;
}


- (void)applicationWillFinishLaunching:(NSNotification *)aNotification
{
  MYX_GRT *grt= myx_grt_initialize(0);
  MYX_GRT_MODULE_LOADER *loader;
  MYX_GRT_ERROR error;

  if(![[NSUserDefaults standardUserDefaults] boolForKey: @"dontShowAlphaWarning"])
  {
    [NSApp beginSheet: alphaWarning
            modalForWindow: nil
            modalDelegate: nil
            didEndSelector: nil
            contextInfo: nil];
    [NSApp runModalForWindow: alphaWarning];
    [NSApp endSheet: alphaWarning];
    [alphaWarning orderOut: self];
  }
  
  [MGenericCanvasView registerSystemColors];
  
  [[[NSThread currentThread] threadDictionary] setObject:[NSNumber numberWithInt:1] forKey:@"mainThread"];

  myx_grt_scan_for_structs(grt, [[NSString stringWithFormat:@"%@/xml",[[NSBundle bundleForClass:[MGRT class]] resourcePath]] fileSystemRepresentation],
                           &error);

  // create a GRT instance with a Java loader, so that the JavaVM will be first initialized
  // in the main thread. further GRT instances will just attach to the main JVM
  loader= myx_java_init_loader(grt, NULL, &error, NULL, 
                               [[NSString stringWithFormat:@"%@/", [[NSBundle bundleForClass:[MGRT class]] resourcePath]] fileSystemRepresentation]);
  if (loader)
  {
    myx_grt_register_module_loader(grt, loader);
    NSLog(@"java loader inited");
  }
  else
    NSLog(@"Error creating JVM!!");
  
  [MPreferences checkDirectory:@"Workbench"];
  
  // setup the global font manager with the font path
  lockFontManager();
  fontManager()->setFontResourcesPath([[[NSBundle mainBundle] resourcePath] UTF8String]);
}


- (IBAction)showAbout:(id)sender
{
  [versionLabel setStringValue:[NSString stringWithFormat:@"Version %@", 
    [[[NSBundle mainBundle] infoDictionary] objectForKey:@"CFBundleVersion"]]];
  
  [aboutPanel makeKeyAndOrderFront:sender];
}


- (void)addPluginGroup:(MGRTValue*)group
                toMenu:(NSMenu*)menu
                   grt:(MGRT*)grt
              selector:(SEL)aSelector
                target:(id)target
         selectedTypes:(NSArray*)types
{
  MGRTValue plugins((*group)["plugins"]);
  MGRTValue subgroups((*group)["subGroups"]);
  id document= [[NSDocumentController sharedDocumentController] currentDocument];

  for (int i= 0; i < plugins.count(); i++)
  {
    MGRTValue plugin(MGRTValue::refObject([grt grt], plugins[i].asString()));
    NSMenuItem *item;    
    BOOL ok= [document plugin:plugin matchesSelection:types];
    item= [[NSMenuItem alloc] initWithTitle:[NSString stringWithUTF8String:plugin["caption"].asString()]
                                     action:ok?aSelector:nil
                              keyEquivalent:@""];
    [item setEnabled:ok];
    if (ok)
      [item setTarget:target];
    
    [item setRepresentedObject:[NSGRTValue grtValueWithValue:plugin.grtValue()]];
    [menu addItem:[item autorelease]];
  }

  for (int i= 0; i < subgroups.count(); i++)
  {
    MGRTValue group(subgroups[i]);
    NSMenuItem *item= [[NSMenuItem alloc] initWithTitle:[NSString stringWithUTF8String:group["name"].asString()]
                                                 action:nil
                                          keyEquivalent:@""];
    NSMenu *submenu= [[[NSMenu alloc] init] autorelease];

    [item setSubmenu:submenu];
    
    [menu addItem:[item autorelease]];
    [self addPluginGroup:&group toMenu:submenu grt:grt selector:aSelector target:target
           selectedTypes:types];
  }
}


- (void)refreshPluginsMenu:(MGRT*)grt action:(SEL)aSelector target:(id)target
{
  NSMenu *menu= [pluginMenuItem submenu];
  MGRTValue rootList([grt globalValue:"/app/pluginGroups"]);
  NSArray *types;

  while ([menu numberOfItems] > 0)
    [menu removeItemAtIndex:0];
  
  types= [[[NSDocumentController sharedDocumentController] currentDocument] selectedObjectTypes];
    
  for (int i= 0; i < rootList.count(); i++)
  {
    MGRTValue group(rootList[i]);
    NSMenuItem *item= [[NSMenuItem alloc] initWithTitle:[NSString stringWithUTF8String:group["name"].asString()]
                                                 action:nil
                                          keyEquivalent:@""];
    NSMenu *submenu= [[NSMenu alloc] initWithTitle:@""];

    [menu addItem:[item autorelease]];
    [item setSubmenu:[submenu autorelease]];

    [self addPluginGroup:&group toMenu:submenu grt:grt selector:aSelector target:target
           selectedTypes:types];
  }
}

- (void)menuNeedsUpdate:(NSMenu *)menu
{
  [[[NSDocumentController sharedDocumentController] currentDocument] menu:menu 
                                                              needsUpdate:self];
}

- (IBAction)closeAlphaStatusWarning:(id)sender
{
  [NSApp stopModal];
}

- (IBAction)closeAlphaStatusWarningAndExit:(id)sender
{
  exit(0);
}

- (IBAction)showWarningSwitched:(id)sender
{
    [[NSUserDefaults standardUserDefaults] setBool: [showWarning state] forKey: @"dontShowAlphaWarning"];
}

@end
