@echo off

rem ------------------------------
rem Create application directories

echo --------------------------------------------
echo Creating application directories ...
echo --------------------------------------------
if not exist ..\..\release\intermediate mkdir ..\..\release\intermediate
if not exist ..\..\release\xml mkdir ..\..\release\xml
if not exist ..\..\release\doc mkdir ..\..\release\doc
if not exist ..\..\release\fonts mkdir ..\..\release\fonts
if not exist ..\..\release\locale mkdir ..\..\release\locale
echo .

echo --------------------------------------------
echo Copying licence files ...
echo --------------------------------------------
if exist ..\..\release\COPYING del ..\..\release\COPYING
if exist ..\..\release\MySQLEULA.txt del ..\..\release\MySQLEULA.txt

copy ..\..\common\res\COPYING ..\..\release\COPYING
echo .

echo Copying XML files
copy ..\..\common\res\mysqlx_dbm_charsets.xml ..\..\release\xml\mysqlx_dbm_charsets.xml
copy ..\..\common\res\mysqlx_dbm_datatypes.xml ..\..\release\xml\mysqlx_dbm_datatypes.xml

copy ..\res\mysqlqb_functions.xml ..\..\release\xml\mysqlqb_functions.xml
copy ..\res\mysqlqb_statements.xml ..\..\release\xml\mysqlqb_statements.xml
echo .

rem ------------------------------
rem copy docs

echo Copying doc files
copy ..\res\doc\main.css ..\..\release\doc\main.css
copy ..\res\doc\mysqlqb_functions.html ..\..\release\doc\mysqlqb_functions.html
copy ..\res\doc\mysqlqb_statements.html ..\..\release\doc\mysqlqb_statements.html
copy ..\res\doc\mysqlqb_quickstart.html ..\..\release\doc\mysqlqb_quickstart.html

rem copy doc\mysqlquerybrowser.chm ..\..\release\mysqlquerybrowser.chm
echo .

rem ------------------------------
rem copy fonts

echo Copying font files
copy ..\..\common\res\fonts\VeraMoBd.ttf ..\..\release\fonts\VeraMoBd.ttf
copy ..\..\common\res\fonts\VeraMoBI.ttf ..\..\release\fonts\VeraMoBI.ttf
copy ..\..\common\res\fonts\VeraMoIt.ttf ..\..\release\fonts\VeraMoIt.ttf
copy ..\..\common\res\fonts\VeraMono.ttf ..\..\release\fonts\VeraMono.ttf
echo .

rem ------------------------------
rem copy translations

echo Copying localization helper files
copy ..\res\MakeMo.bat ..\..\release\locale\
copy ..\..\common\res\how_to_translate.txt ..\..\release\locale\
copy ..\..\common\res\languages_list.txt ..\..\release\locale\
echo.

echo -------------------------------------------------------
echo Generating translation files...
echo -------------------------------------------------------
call MakeTranslations.cmd "..\..\release"

echo .
