grtV.setGlobal("/model/catalog",
   ReverseEngineeringMysql:reverseEngineer(
     {{host="localhost", user="root", password="root", port=3309},
     {"test"}}))

function createSchemaFigures(canvas, schema, layer)
  local x= 150
  local y= 150
   
  if canvas == nil then
    canvas= grtV.getGlobal("/model/canvas")
  end
  if schema == nil then
    schema= grtV.getGlobal("/model/catalog/schemata/0")
  end
  if layer == nil then
    layer = grtV.getGlobal("/model/canvas/layers/0")
  end

  for i= 1, grtV.getn(schema.tables) do
    -- create figure
    local grtTable = schema.tables[i]
    local figure= GenericCanvas:grtToFigure({canvas, grtTable, "full"})
    figure.name= grtV.toLua(grtTable.name)
  
    -- create figure instance
    local instance = GenericCanvas:createFigureInstance({layer, figure})
    instance.name= grtV.toLua(grtTable.name)
  
    -- set pk columns
    if grtTable.primaryKey ~= nil then
      for i= 1, grtV.getn(grtTable.columns) do
        local col= grtTable.columns[i]
  
        local isPk= false
        for j= 1, grtV.getn(grtTable.primaryKey.columns) do
          if (grtV.toLua(col._id) == grtV.toLua(grtTable.primaryKey.columns[j])) then
            isPk= true
            break
          end
        end
  
        if isPk then
          local figureElement= GenericCanvas:grtGetFigureElement({figure, "/columns", i - 1})
          figureElement.style = "db.column.pk"
          --print(col.name)
        end
      end
    end

    -- arrange table
    instance.translation[1] = x
    instance.translation[2] = y

    x= x + 350
    if x > 3000 then
      x= 150
      y= y + 400
    end
  end
   
  GenericCanvas:refresh(canvas)
end

createSchemaFigures()

