/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.exceptions.SQLExceptionSapDB;
import com.sap.dbtech.jdbc.translators.StructureTranslator;
import com.sap.dbtech.util.MessageTranslator;
import com.sap.dbtech.util.StructuredBytes;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLOutput;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;

public class StructureSQLOutput
implements SQLOutput {
    private StructuredBytes data;
    private StructureTranslator translator;
    private int fieldIndex;

    public StructureSQLOutput(StructureTranslator structureTranslator) {
        this.translator = structureTranslator;
        this.data = new StructuredBytes(structureTranslator.logicalLength);
        this.fieldIndex = -1;
    }

    public boolean isDataComplete() {
        return this.fieldIndex == this.translator.parameterStructure.getMemberCount();
    }

    public byte[] getData() throws SQLException {
        if (!this.isDataComplete()) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.structure.incomplete"));
        }
        return this.data.bytes();
    }

    private void checkDataComplete() throws SQLException {
        if (this.isDataComplete()) {
            throw new SQLExceptionSapDB(MessageTranslator.translate("error.structure.complete"));
        }
    }

    public void writeByte(byte by) throws SQLException {
        try {
            ++this.fieldIndex;
            this.checkDataComplete();
        }
        catch (SQLException sQLException) {
            --this.fieldIndex;
            throw sQLException;
        }
    }

    public void writeDouble(double d) throws SQLException {
    }

    public void writeFloat(float f) throws SQLException {
    }

    public void writeInt(int n) throws SQLException {
    }

    public void writeLong(long l) throws SQLException {
    }

    public void writeShort(short s) throws SQLException {
    }

    public void writeBoolean(boolean bl) throws SQLException {
    }

    public void writeBytes(byte[] byArray) throws SQLException {
    }

    public void writeAsciiStream(InputStream inputStream) throws SQLException {
    }

    public void writeBinaryStream(InputStream inputStream) throws SQLException {
    }

    public void writeCharacterStream(Reader reader) throws SQLException {
    }

    public void writeString(String string) throws SQLException {
    }

    public void writeBigDecimal(BigDecimal bigDecimal) throws SQLException {
    }

    public void writeURL(URL uRL) throws SQLException {
    }

    public void writeArray(Array array) throws SQLException {
    }

    public void writeBlob(Blob blob) throws SQLException {
    }

    public void writeClob(Clob clob) throws SQLException {
    }

    public void writeDate(Date date) throws SQLException {
    }

    public void writeRef(Ref ref) throws SQLException {
    }

    public void writeObject(SQLData sQLData) throws SQLException {
    }

    public void writeStruct(Struct struct) throws SQLException {
    }

    public void writeTime(Time time) throws SQLException {
    }

    public void writeTimestamp(Timestamp timestamp) throws SQLException {
    }
}

