/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.ssl;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

class TdsTlsInputStream
extends FilterInputStream {
    int bytesOutstanding = 0;
    byte[] readBuffer = new byte[6144];
    InputStream bufferStream = null;
    boolean pureSSL = false;

    public TdsTlsInputStream(InputStream in) {
        super(in);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.pureSSL && this.bufferStream == null) {
            return this.in.read(b, off, len);
        }
        if (!this.pureSSL && this.bufferStream == null) {
            this.primeBuffer();
        }
        int ret = this.bufferStream.read(b, off, len);
        this.bytesOutstanding -= ret;
        if (this.bytesOutstanding == 0) {
            this.bufferStream = null;
        }
        return ret;
    }

    private void primeBuffer() throws IOException {
        int len;
        this.in.read(this.readBuffer, 0, 5);
        if (this.readBuffer[0] == 4) {
            len = (this.readBuffer[2] & 0xFF) << 8 | this.readBuffer[3] & 0xFF;
            this.in.read(this.readBuffer, 5, 3);
            this.in.read(this.readBuffer, 0, len -= 8);
        } else {
            len = (this.readBuffer[3] & 0xFF) << 8 | this.readBuffer[4] & 0xFF;
            this.in.read(this.readBuffer, 5, len - 5);
            this.pureSSL = true;
        }
        this.bufferStream = new ByteArrayInputStream(this.readBuffer, 0, len);
        this.bytesOutstanding = len;
    }
}

