/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc.cache;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.jtds.jdbc.cache.AbstractStatementCache;

public class DefaultStatementCache
extends AbstractStatementCache {
    private HashMap cache = new HashMap();

    public DefaultStatementCache(int maximumCacheTarget) {
        super(maximumCacheTarget);
    }

    public synchronized Object get(String key) {
        return this.cache.get(key);
    }

    public synchronized void put(String key, Object handle) {
        this.cache.put(key, handle);
        this.latch(handle);
    }

    public synchronized void remove(String key) {
        this.removeLatches(this.cache.remove(key));
    }

    public synchronized Collection getObsoleteHandles(Collection handles) {
        int cacheOverrun = this.cache.size() - this.maximumCacheTarget;
        this.unlatch(handles);
        if (cacheOverrun <= 0) {
            return null;
        }
        ArrayList obsoleteHandles = new ArrayList(cacheOverrun);
        Iterator iterator = this.cache.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry mapEntry = iterator.next();
            if (this.isLatched(mapEntry.getValue())) continue;
            obsoleteHandles.add(mapEntry.getValue());
            iterator.remove();
            if (--cacheOverrun == 0) break;
        }
        if (obsoleteHandles.size() == 0) {
            return null;
        }
        return obsoleteHandles;
    }
}

