/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jtds.jdbc;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.ref.WeakReference;
import java.net.UnknownHostException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.sourceforge.jtds.jdbc.CharsetInfo;
import net.sourceforge.jtds.jdbc.ColInfo;
import net.sourceforge.jtds.jdbc.DefaultProperties;
import net.sourceforge.jtds.jdbc.JtdsCallableStatement;
import net.sourceforge.jtds.jdbc.JtdsDatabaseMetaData;
import net.sourceforge.jtds.jdbc.JtdsPreparedStatement;
import net.sourceforge.jtds.jdbc.JtdsStatement;
import net.sourceforge.jtds.jdbc.MSSqlServerInfo;
import net.sourceforge.jtds.jdbc.Messages;
import net.sourceforge.jtds.jdbc.ParamInfo;
import net.sourceforge.jtds.jdbc.SQLDiagnostic;
import net.sourceforge.jtds.jdbc.SQLParser;
import net.sourceforge.jtds.jdbc.Semaphore;
import net.sourceforge.jtds.jdbc.SharedLocalNamedPipe;
import net.sourceforge.jtds.jdbc.SharedNamedPipe;
import net.sourceforge.jtds.jdbc.SharedSocket;
import net.sourceforge.jtds.jdbc.Support;
import net.sourceforge.jtds.jdbc.TdsCore;
import net.sourceforge.jtds.jdbc.TdsData;
import net.sourceforge.jtds.jdbc.cache.DefaultStatementCache;
import net.sourceforge.jtds.jdbc.cache.FastStatementCache;
import net.sourceforge.jtds.jdbc.cache.NonCachingStatementCache;
import net.sourceforge.jtds.jdbc.cache.StatementCache;
import net.sourceforge.jtds.util.Logger;
import net.sourceforge.jtds.util.TimerThread;

public class ConnectionJDBC2
implements Connection {
    private static final String SYBASE_SERVER_CHARSET_QUERY = "select name from master.dbo.syscharsets where id = (select value from master.dbo.sysconfigures where config=131)";
    private static final String SQL_SERVER_65_CHARSET_QUERY = "select name from master.dbo.syscharsets where id = (select csid from master.dbo.syscharsets, master.dbo.sysconfigures where config=1123 and id = value)";
    private String SYBASE_INITIAL_SQL = "SET TRANSACTION ISOLATION LEVEL 1\r\nSET CHAINED OFF\r\nSET QUOTED_IDENTIFIER ON\r\nSET TEXTSIZE 2147483647";
    private String SQL_SERVER_INITIAL_SQL = "SELECT @@MAX_PRECISION\r\nSET TRANSACTION ISOLATION LEVEL READ COMMITTED\r\nSET IMPLICIT_TRANSACTIONS OFF\r\nSET QUOTED_IDENTIFIER ON\r\nSET TEXTSIZE 2147483647";
    private String url;
    private String serverName;
    private int portNumber;
    private int serverType;
    private String instanceName;
    private String databaseName;
    private String currentDatabase;
    private String domainName;
    private String user;
    private String password;
    private String serverCharset;
    private String appName;
    private String progName;
    private String language;
    private String macAddress;
    private int tdsVersion;
    private SharedSocket socket;
    private TdsCore baseTds;
    private int netPacketSize = 512;
    private int packetSize;
    private byte[] collation;
    private boolean charsetSpecified = false;
    private String databaseProductName;
    private String databaseProductVersion;
    private int databaseMajorVersion;
    private int databaseMinorVersion;
    private boolean closed = false;
    private boolean readOnly = false;
    private ArrayList statements;
    private int transactionIsolation = 2;
    private boolean autoCommit = true;
    private SQLDiagnostic messages;
    private int rowCount = 0;
    private int textSize = 0;
    private int maxPrecision = 38;
    private int spSequenceNo = 1;
    private ArrayList procInTran = new ArrayList();
    private CharsetInfo charsetInfo;
    private int prepareSql;
    private long lobBuffer;
    private int maxStatements;
    private StatementCache statementCache;
    private boolean useUnicode = true;
    private boolean namedPipe = false;
    private boolean lastUpdateCount = false;
    private boolean tcpNoDelay = true;
    private int loginTimeout = 0;
    private int sybaseInfo = 0;
    private boolean xaTransaction = false;
    private int xaState = 0;
    private Object xid;
    private boolean xaEmulation = true;
    private Semaphore mutex = new Semaphore(1L);
    private String ssl;

    private ConnectionJDBC2() {
    }

    ConnectionJDBC2(String url, Properties info) throws SQLException {
        this.statements = new ArrayList();
        this.url = url;
        this.unpackProperties(info);
        this.messages = new SQLDiagnostic(this.serverType);
        if (this.instanceName.length() > 0 && !this.namedPipe) {
            MSSqlServerInfo msInfo = new MSSqlServerInfo(this.serverName);
            this.portNumber = msInfo.getPortForInstance(this.instanceName);
            if (this.portNumber == -1) {
                throw new SQLException(Messages.get("error.msinfo.badinst", this.serverName, this.instanceName), "08003");
            }
        }
        SharedSocket.setMemoryBudget(100000);
        SharedSocket.setMinMemPkts(8);
        try {
            this.socket = this.namedPipe ? ((this.serverName == null || this.serverName.equals(".") || this.serverName.startsWith("127.") || this.serverName.equalsIgnoreCase("localhost")) && System.getProperty("os.name").toLowerCase().startsWith("windows") ? new SharedLocalNamedPipe(this.tdsVersion, this.serverType, this.instanceName) : SharedNamedPipe.instance(this.serverName, this.tdsVersion, this.serverType, this.packetSize, this.instanceName, this.domainName, this.user, this.password)) : new SharedSocket(this.serverName, this.portNumber, this.tdsVersion, this.serverType, this.tcpNoDelay);
            if (this.charsetSpecified) {
                this.loadCharset(this.serverCharset);
            } else {
                this.loadCharset("iso_1");
            }
            this.baseTds = new TdsCore(this, this.messages);
            Object timer = null;
            if (this.loginTimeout > 0) {
                timer = TimerThread.getInstance().setTimer(this.loginTimeout * 1000, new TimerThread.TimerListener(){

                    public void timerExpired() {
                        ConnectionJDBC2.this.socket.forceClose();
                    }
                });
            }
            if (this.tdsVersion >= 4 && !this.namedPipe) {
                this.baseTds.negotiateSSL(this.instanceName, this.ssl);
            }
            this.baseTds.login(this.serverName, this.databaseName, this.user, this.password, this.domainName, this.serverCharset, this.appName, this.progName, this.language, this.macAddress, this.packetSize);
            if (timer != null) {
                TimerThread.getInstance().cancelTimer(timer);
            }
            this.tdsVersion = this.baseTds.getTdsVersion();
            if (this.tdsVersion < 3 && this.databaseName.length() > 0) {
                this.setCatalog(this.databaseName);
            }
        }
        catch (UnknownHostException e) {
            throw Support.linkException(new SQLException(Messages.get("error.connection.badhost", e.getMessage()), "08S03"), e);
        }
        catch (IOException e) {
            throw Support.linkException(new SQLException(Messages.get("error.connection.ioerror", e.getMessage()), "08S01"), e);
        }
        catch (SQLException e) {
            if (this.loginTimeout > 0 && e.getMessage().indexOf("socket closed") >= 0) {
                throw new SQLException(Messages.get("error.connection.timeout"), "HYT01");
            }
            throw e;
        }
        if ((this.serverCharset == null || this.serverCharset.length() == 0) && this.collation == null) {
            this.loadCharset(this.determineServerCharset());
        }
        if (this.serverType == 2) {
            this.baseTds.submitSQL(this.SYBASE_INITIAL_SQL);
        } else {
            Statement stmt = this.createStatement();
            ResultSet rs = stmt.executeQuery(this.SQL_SERVER_INITIAL_SQL);
            if (rs.next()) {
                this.maxPrecision = rs.getByte(1);
            }
            rs.close();
            stmt.close();
        }
    }

    SharedSocket getSocket() {
        return this.socket;
    }

    int getTdsVersion() {
        return this.tdsVersion;
    }

    String getProcName() {
        String seq = "000000" + Integer.toHexString(this.spSequenceNo++).toUpperCase();
        return "#jtds" + seq.substring(seq.length() - 6, seq.length());
    }

    synchronized String prepareSQL(JtdsPreparedStatement pstmt, String sql, ParamInfo[] params, boolean returnKeys) throws SQLException {
        if (this.prepareSql == 0 || this.prepareSql == 2) {
            return null;
        }
        if (this.serverType == 2) {
            if (this.tdsVersion != 2) {
                return null;
            }
            if (returnKeys) {
                return null;
            }
            if (pstmt.getResultSetConcurrency() == 1008 || pstmt.getResultSetType() != 1003 || pstmt.cursorName != null) {
                return null;
            }
        }
        int i = 0;
        while (i < params.length) {
            if (!params[i].isSet) {
                throw new SQLException(Messages.get("error.prepare.paramnotset", Integer.toString(i + 1)), "07000");
            }
            TdsData.getNativeType(this, params[i]);
            if (this.serverType == 2 && (params[i].sqlType.equals("text") || params[i].sqlType.equals("image"))) {
                return null;
            }
            ++i;
        }
        String key = Support.getStatementKey(sql, params, this.serverType, this.getCatalog());
        ProcEntry proc = (ProcEntry)this.statementCache.get(key);
        if (proc != null) {
            if (this.serverType == 2) {
                pstmt.setColMetaData(proc.colMetaData);
                pstmt.setParamMetaData(proc.paramMetaData);
            }
            return proc.name;
        }
        proc = new ProcEntry();
        if (this.serverType == 1) {
            proc.name = this.baseTds.microsoftPrepare(sql, params, pstmt.getResultSetType(), pstmt.getResultSetConcurrency());
            if (proc.name == null) {
                return null;
            }
        } else {
            proc.name = this.baseTds.sybasePrepare(sql, params);
            if (proc.name == null) {
                return null;
            }
            ProcEntry.access$102(proc, this.baseTds.getColumns());
            ProcEntry.access$202(proc, this.baseTds.getParameters());
            pstmt.setColMetaData(proc.colMetaData);
            pstmt.setParamMetaData(proc.paramMetaData);
        }
        this.addCachedProcedure(key, proc);
        if (pstmt.handles == null) {
            pstmt.handles = new ArrayList(1);
        }
        pstmt.handles.add(proc);
        return proc.name;
    }

    void addCachedProcedure(String key, ProcEntry proc) {
        this.statementCache.put(key, proc);
        if (!this.autoCommit) {
            this.procInTran.add(key);
        }
    }

    void removeCachedProcedure(String key) {
        this.statementCache.remove(key);
        if (!this.autoCommit) {
            ((AbstractCollection)this.procInTran).remove(key);
        }
    }

    int getServerType() {
        return this.serverType;
    }

    void setNetPacketSize(int size) {
        this.netPacketSize = size;
    }

    int getNetPacketSize() {
        return this.netPacketSize;
    }

    int getRowCount() {
        return this.rowCount;
    }

    void setRowCount(int count) {
        this.rowCount = count;
    }

    public int getTextSize() {
        return this.textSize;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    boolean isLastUpdateCount() {
        return this.lastUpdateCount;
    }

    int getMaxPrecision() {
        return this.maxPrecision;
    }

    long getLobBuffer() {
        return this.lobBuffer;
    }

    int getPrepareSql() {
        return this.prepareSql;
    }

    protected void unpackProperties(Properties info) throws SQLException {
        this.serverName = info.getProperty(Messages.get("prop.servername"));
        this.portNumber = this.parseIntegerProperty(info, "prop.portnumber");
        this.serverType = this.parseIntegerProperty(info, "prop.servertype");
        this.databaseName = info.getProperty(Messages.get("prop.databasename"));
        this.instanceName = info.getProperty(Messages.get("prop.instance"));
        this.domainName = info.getProperty(Messages.get("prop.domain"));
        this.user = info.getProperty(Messages.get("prop.user"));
        this.password = info.getProperty(Messages.get("prop.password"));
        this.macAddress = info.getProperty(Messages.get("prop.macaddress"));
        this.appName = info.getProperty(Messages.get("prop.appname"));
        this.progName = info.getProperty(Messages.get("prop.progname"));
        this.serverCharset = info.getProperty(Messages.get("prop.charset"));
        this.language = info.getProperty(Messages.get("prop.language"));
        this.prepareSql = this.parseIntegerProperty(info, "prop.preparesql");
        this.lastUpdateCount = "true".equalsIgnoreCase(info.getProperty(Messages.get("prop.lastupdatecount")));
        this.useUnicode = "true".equalsIgnoreCase(info.getProperty(Messages.get("prop.useunicode")));
        this.namedPipe = "true".equalsIgnoreCase(info.getProperty(Messages.get("prop.namedpipe")));
        this.tcpNoDelay = "true".equalsIgnoreCase(info.getProperty(Messages.get("prop.tcpnodelay")));
        this.xaEmulation = "true".equalsIgnoreCase(info.getProperty(Messages.get("prop.xaemulation")));
        this.charsetSpecified = this.serverCharset.length() > 0;
        Integer parsedTdsVersion = DefaultProperties.getTdsVersion(info.getProperty(Messages.get("prop.tds")));
        if (parsedTdsVersion == null) {
            throw new SQLException(Messages.get("error.connection.badprop", Messages.get("prop.tds")), "08001");
        }
        this.tdsVersion = parsedTdsVersion;
        this.packetSize = this.parseIntegerProperty(info, "prop.packetsize");
        if (this.packetSize < 512) {
            this.packetSize = this.tdsVersion >= 3 ? (this.packetSize == 0 ? 0 : 4096) : 512;
        }
        if (this.packetSize > 32768) {
            this.packetSize = 32768;
        }
        this.packetSize = this.packetSize / 512 * 512;
        this.loginTimeout = this.parseIntegerProperty(info, "prop.logintimeout");
        this.lobBuffer = this.parseLongProperty(info, "prop.lobbuffer");
        this.maxStatements = this.parseIntegerProperty(info, "prop.maxstatements");
        this.statementCache = this.maxStatements <= 0 ? new NonCachingStatementCache() : (this.maxStatements == Integer.MAX_VALUE ? new FastStatementCache() : new DefaultStatementCache(this.maxStatements));
        if (this.tdsVersion < 4 && this.prepareSql == 4) {
            this.prepareSql = 3;
        }
        if (this.tdsVersion < 3 && this.prepareSql == 3) {
            this.prepareSql = 2;
        }
        if (this.tdsVersion < 2 && this.prepareSql == 2) {
            this.prepareSql = 1;
        }
        this.ssl = info.getProperty(Messages.get("prop.ssl"));
    }

    private int parseIntegerProperty(Properties info, String key) throws SQLException {
        String propertyName = Messages.get(key);
        try {
            return Integer.parseInt(info.getProperty(propertyName));
        }
        catch (NumberFormatException e) {
            throw new SQLException(Messages.get("error.connection.badprop", propertyName), "08001");
        }
    }

    private long parseLongProperty(Properties info, String key) throws SQLException {
        String propertyName = Messages.get(key);
        try {
            return Long.parseLong(info.getProperty(propertyName));
        }
        catch (NumberFormatException e) {
            throw new SQLException(Messages.get("error.connection.badprop", propertyName), "08001");
        }
    }

    protected String getCharset() {
        return this.charsetInfo.getCharset();
    }

    protected boolean isWideChar() {
        return this.charsetInfo.isWideChars();
    }

    protected CharsetInfo getCharsetInfo() {
        return this.charsetInfo;
    }

    protected boolean isUseUnicode() {
        return this.useUnicode;
    }

    protected boolean getSybaseInfo(int flag) {
        return (this.sybaseInfo & flag) != 0;
    }

    protected void setSybaseInfo(int mask) {
        this.sybaseInfo = mask;
    }

    protected void setServerCharset(String charset) throws SQLException {
        if (this.charsetSpecified) {
            Logger.println("Server charset " + charset + ". Ignoring as driver requested " + this.serverCharset);
            return;
        }
        if (!charset.equals(this.serverCharset)) {
            this.loadCharset(charset);
            if (Logger.isActive()) {
                Logger.println("Set charset to " + this.serverCharset + '/' + this.charsetInfo);
            }
        }
    }

    private void loadCharset(String charset) throws SQLException {
        CharsetInfo tmp = CharsetInfo.getCharset(charset);
        if (tmp == null) {
            throw new SQLException(Messages.get("error.charset.nomapping", charset), "2C000");
        }
        try {
            "This is a test".getBytes(tmp.getCharset());
            this.charsetInfo = tmp;
        }
        catch (UnsupportedEncodingException ex) {
            throw new SQLException(Messages.get("error.charset.invalid", charset, this.charsetInfo.getCharset()), "2C000");
        }
        this.socket.setCharsetInfo(this.charsetInfo);
        this.serverCharset = charset;
    }

    private String determineServerCharset() throws SQLException {
        String queryStr = null;
        switch (this.serverType) {
            case 1: {
                if (this.databaseProductVersion.indexOf("6.5") >= 0) {
                    queryStr = SQL_SERVER_65_CHARSET_QUERY;
                    break;
                }
                throw new SQLException("Please use TDS protocol version 7.0 or higher");
            }
            case 2: {
                queryStr = SYBASE_SERVER_CHARSET_QUERY;
            }
        }
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery(queryStr);
        rs.next();
        String charset = rs.getString(1);
        rs.close();
        stmt.close();
        return charset;
    }

    void setCollation(byte[] collation) throws SQLException {
        CharsetInfo tmp = CharsetInfo.getCharset(collation);
        try {
            "This is a test".getBytes(tmp.getCharset());
            this.charsetInfo = tmp;
        }
        catch (UnsupportedEncodingException ex) {
            throw new SQLException(Messages.get("error.charset.invalid", Support.toHex(collation), this.charsetInfo.getCharset()), "2C000");
        }
        this.socket.setCharsetInfo(this.charsetInfo);
        this.collation = collation;
    }

    byte[] getCollation() {
        return this.collation;
    }

    protected void setDatabase(String newDb, String oldDb) throws SQLException {
        if (this.currentDatabase != null && !oldDb.equalsIgnoreCase(this.currentDatabase)) {
            throw new SQLException(Messages.get("error.connection.dbmismatch", oldDb, this.databaseName), "HY096");
        }
        this.currentDatabase = newDb;
        if (Logger.isActive()) {
            Logger.println("Changed database from " + oldDb + " to " + newDb);
        }
    }

    protected void setDBServerInfo(String databaseProductName, int databaseMajorVersion, int databaseMinorVersion, int buildNumber) {
        this.databaseProductName = databaseProductName;
        this.databaseMajorVersion = databaseMajorVersion;
        this.databaseMinorVersion = databaseMinorVersion;
        if (this.tdsVersion >= 3) {
            StringBuffer buf = new StringBuffer(10);
            if (databaseMajorVersion < 10) {
                buf.append('0');
            }
            buf.append(databaseMajorVersion).append('.');
            if (databaseMinorVersion < 10) {
                buf.append('0');
            }
            buf.append(databaseMinorVersion).append('.');
            buf.append(buildNumber);
            while (buf.length() < 10) {
                buf.insert(6, '0');
            }
            this.databaseProductVersion = buf.toString();
        } else {
            this.databaseProductVersion = databaseMajorVersion + "." + databaseMinorVersion;
        }
    }

    synchronized void removeStatement(JtdsStatement statement) throws SQLException {
        Collection handles;
        int i = 0;
        while (i < this.statements.size()) {
            Statement stmt;
            WeakReference wr = (WeakReference)this.statements.get(i);
            if (wr != null && (stmt = (Statement)wr.get()) != null && stmt == statement) {
                this.statements.set(i, null);
            }
            ++i;
        }
        if (statement instanceof JtdsPreparedStatement && (handles = this.statementCache.getObsoleteHandles(((JtdsPreparedStatement)statement).handles)) != null) {
            StringBuffer cleanupSql = new StringBuffer(handles.size() * 32);
            Iterator iterator = handles.iterator();
            while (iterator.hasNext()) {
                String handle = iterator.next().toString();
                if (TdsCore.isPreparedProcedureName(handle)) {
                    cleanupSql.append("EXEC sp_unprepare ");
                } else {
                    cleanupSql.append("DROP PROC ");
                }
                cleanupSql.append(handle);
                cleanupSql.append('\n');
            }
            this.baseTds.executeSQL(cleanupSql.toString(), null, null, true, 0, -1, -1, true);
            this.baseTds.clearResponseQueue();
        }
    }

    void addStatement(JtdsStatement statement) {
        ArrayList arrayList = this.statements;
        synchronized (arrayList) {
            int i = 0;
            while (i < this.statements.size()) {
                WeakReference wr = (WeakReference)this.statements.get(i);
                if (wr == null) {
                    this.statements.set(i, new WeakReference<JtdsStatement>(statement));
                    return;
                }
                ++i;
            }
            this.statements.add(new WeakReference<JtdsStatement>(statement));
        }
    }

    void checkOpen() throws SQLException {
        if (this.closed) {
            throw new SQLException(Messages.get("error.generic.closed", "Connection"), "HY010");
        }
    }

    void checkLocal(String method) throws SQLException {
        if (this.xaTransaction) {
            throw new SQLException(Messages.get("error.connection.badxaop", method), "HY010");
        }
    }

    void notImplemented(String method) throws SQLException {
        throw new SQLException(Messages.get("error.generic.notimp", method), "HYC00");
    }

    int getDatabaseMajorVersion() {
        return this.databaseMajorVersion;
    }

    int getDatabaseMinorVersion() {
        return this.databaseMinorVersion;
    }

    String getDatabaseProductName() {
        return this.databaseProductName;
    }

    String getDatabaseProductVersion() {
        return this.databaseProductVersion;
    }

    String getURL() {
        return this.url;
    }

    public String getRmHost() {
        return this.serverName + ":" + this.portNumber;
    }

    void setClosed() {
        this.closed = true;
    }

    synchronized byte[][] sendXaPacket(int[] args, byte[] data) throws SQLException {
        ParamInfo[] params = new ParamInfo[]{new ParamInfo(4, null, 2), new ParamInfo(4, new Integer(args[1]), 0), new ParamInfo(4, new Integer(args[2]), 0), new ParamInfo(4, new Integer(args[3]), 0), new ParamInfo(4, new Integer(args[4]), 0), new ParamInfo(-3, data, 1)};
        this.baseTds.executeSQL(null, "master..xp_jtdsxa", params, false, 0, -1, -1, true);
        ArrayList<Object> xids = new ArrayList<Object>();
        while (!this.baseTds.isEndOfResponse()) {
            if (!this.baseTds.getMoreResults()) continue;
            while (this.baseTds.getNextRow()) {
                Object[] row = this.baseTds.getRowData();
                if (row.length != 1 || !(row[0] instanceof byte[])) continue;
                xids.add(row[0]);
            }
        }
        this.messages.checkErrors();
        args[0] = params[0].getOutValue() instanceof Integer ? (Integer)params[0].getOutValue() : -7;
        if (xids.size() > 0) {
            byte[][] list = new byte[xids.size()][];
            int i = 0;
            while (i < xids.size()) {
                list[i] = (byte[])xids.get(i);
                ++i;
            }
            return list;
        }
        if (params[5].getOutValue() instanceof byte[]) {
            byte[][] cookie = new byte[][]{(byte[])params[5].getOutValue()};
            return cookie;
        }
        return null;
    }

    synchronized void enlistConnection(byte[] oleTranID) throws SQLException {
        if (oleTranID != null) {
            this.prepareSql = 2;
            this.baseTds.enlistConnection(1, oleTranID);
            this.xaTransaction = true;
        } else {
            this.baseTds.enlistConnection(1, null);
            this.xaTransaction = false;
        }
    }

    void setXid(Object xid) {
        this.xid = xid;
        this.xaTransaction = xid != null;
    }

    Object getXid() {
        return this.xid;
    }

    void setXaState(int value) {
        this.xaState = value;
    }

    int getXaState() {
        return this.xaState;
    }

    boolean isXaEmulation() {
        return this.xaEmulation;
    }

    Semaphore getMutex() {
        return this.mutex;
    }

    public int getHoldability() throws SQLException {
        this.checkOpen();
        return 1;
    }

    public int getTransactionIsolation() throws SQLException {
        this.checkOpen();
        return this.transactionIsolation;
    }

    public void clearWarnings() throws SQLException {
        this.checkOpen();
        this.messages.clearWarnings();
    }

    public synchronized void close() throws SQLException {
        if (!this.closed) {
            try {
                try {
                    ArrayList tmpList;
                    ArrayList arrayList = this.statements;
                    synchronized (arrayList) {
                        tmpList = new ArrayList(this.statements);
                    }
                    int i = 0;
                    while (i < tmpList.size()) {
                        Statement stmt;
                        WeakReference wr = (WeakReference)tmpList.get(i);
                        if (wr != null && (stmt = (Statement)wr.get()) != null) {
                            stmt.close();
                        }
                        ++i;
                    }
                    this.baseTds.closeConnection();
                    this.baseTds.close();
                    this.socket.close();
                }
                catch (IOException e) {
                    Object var7_9 = null;
                    this.closed = true;
                }
                Object var7_8 = null;
                this.closed = true;
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                this.closed = true;
                throw throwable;
            }
        }
    }

    public synchronized void commit() throws SQLException {
        this.checkOpen();
        this.checkLocal("commit");
        if (this.getAutoCommit()) {
            throw new SQLException(Messages.get("error.connection.autocommit"), "25000");
        }
        this.baseTds.submitSQL("IF @@TRANCOUNT > 0 COMMIT TRAN");
        this.procInTran.clear();
        this.clearSavepoints();
    }

    public synchronized void rollback() throws SQLException {
        this.checkOpen();
        this.checkLocal("rollback");
        if (this.getAutoCommit()) {
            throw new SQLException(Messages.get("error.connection.autocommit"), "25000");
        }
        this.baseTds.submitSQL("IF @@TRANCOUNT > 0 ROLLBACK TRAN");
        int i = 0;
        while (i < this.procInTran.size()) {
            String key = (String)this.procInTran.get(i);
            if (key != null && this.tdsVersion != 2) {
                this.statementCache.remove(key);
            }
            ++i;
        }
        this.procInTran.clear();
        this.clearSavepoints();
    }

    public boolean getAutoCommit() throws SQLException {
        this.checkOpen();
        return this.autoCommit;
    }

    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    public boolean isReadOnly() throws SQLException {
        this.checkOpen();
        return this.readOnly;
    }

    public void setHoldability(int holdability) throws SQLException {
        this.checkOpen();
        switch (holdability) {
            case 1: {
                break;
            }
            case 2: {
                throw new SQLException(Messages.get("error.generic.optvalue", "CLOSE_CURSORS_AT_COMMIT", "setHoldability"), "HY092");
            }
            default: {
                throw new SQLException(Messages.get("error.generic.badoption", Integer.toString(holdability), "setHoldability"), "HY092");
            }
        }
    }

    public synchronized void setTransactionIsolation(int level) throws SQLException {
        this.checkOpen();
        if (this.transactionIsolation == level) {
            return;
        }
        String sql = "SET TRANSACTION ISOLATION LEVEL ";
        boolean sybase = this.serverType == 2;
        switch (level) {
            case 1: {
                sql = sql + (sybase ? "0" : "READ UNCOMMITTED");
                break;
            }
            case 2: {
                sql = sql + (sybase ? "1" : "READ COMMITTED");
                break;
            }
            case 4: {
                sql = sql + (sybase ? "2" : "REPEATABLE READ");
                break;
            }
            case 8: {
                sql = sql + (sybase ? "3" : "SERIALIZABLE");
                break;
            }
            case 0: {
                throw new SQLException(Messages.get("error.generic.optvalue", "TRANSACTION_NONE", "setTransactionIsolation"), "HY024");
            }
            default: {
                throw new SQLException(Messages.get("error.generic.badoption", Integer.toString(level), "setTransactionIsolation"), "HY092");
            }
        }
        this.transactionIsolation = level;
        this.baseTds.submitSQL(sql);
    }

    public synchronized void setAutoCommit(boolean autoCommit) throws SQLException {
        this.checkOpen();
        this.checkLocal("setAutoCommit");
        if (!this.autoCommit) {
            this.commit();
        }
        if (this.autoCommit == autoCommit) {
            return;
        }
        String sql = this.serverType == 2 ? (autoCommit ? "SET CHAINED OFF" : "SET CHAINED ON") : (autoCommit ? "SET IMPLICIT_TRANSACTIONS OFF" : "SET IMPLICIT_TRANSACTIONS ON");
        this.baseTds.submitSQL(sql);
        this.autoCommit = autoCommit;
    }

    public void setReadOnly(boolean readOnly) throws SQLException {
        this.checkOpen();
        this.readOnly = readOnly;
    }

    public String getCatalog() throws SQLException {
        this.checkOpen();
        return this.currentDatabase;
    }

    public synchronized void setCatalog(String catalog) throws SQLException {
        this.checkOpen();
        if (this.currentDatabase != null && this.currentDatabase.equals(catalog)) {
            return;
        }
        if (catalog.length() > 32 || catalog.length() < 1) {
            throw new SQLException(Messages.get("error.generic.badparam", catalog, "setCatalog"), "3D000");
        }
        String sql = this.tdsVersion >= 3 ? "use [" + catalog + ']' : "use " + catalog;
        this.baseTds.submitSQL(sql);
    }

    public DatabaseMetaData getMetaData() throws SQLException {
        this.checkOpen();
        return new JtdsDatabaseMetaData(this);
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkOpen();
        return this.messages.getWarnings();
    }

    public Savepoint setSavepoint() throws SQLException {
        this.checkOpen();
        this.notImplemented("Connection.setSavepoint()");
        return null;
    }

    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this.notImplemented("Connection.releaseSavepoint(Savepoint)");
    }

    public void rollback(Savepoint savepoint) throws SQLException {
        this.checkOpen();
        this.notImplemented("Connection.rollback(Savepoint)");
    }

    public Statement createStatement() throws SQLException {
        this.checkOpen();
        return this.createStatement(1003, 1007);
    }

    public Statement createStatement(int type, int concurrency) throws SQLException {
        this.checkOpen();
        JtdsStatement stmt = new JtdsStatement(this, type, concurrency);
        this.addStatement(stmt);
        return stmt;
    }

    public Statement createStatement(int type, int concurrency, int holdability) throws SQLException {
        this.checkOpen();
        this.setHoldability(holdability);
        return this.createStatement(type, concurrency);
    }

    public Map getTypeMap() throws SQLException {
        this.checkOpen();
        return new HashMap();
    }

    public void setTypeMap(Map map) throws SQLException {
        this.checkOpen();
        this.notImplemented("Connection.setTypeMap(Map)");
    }

    public String nativeSQL(String sql) throws SQLException {
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new SQLException(Messages.get("error.generic.nosql"), "HY000");
        }
        String[] result = new SQLParser(sql, new ArrayList(), this).parse(false);
        return result[0];
    }

    public CallableStatement prepareCall(String sql) throws SQLException {
        this.checkOpen();
        return this.prepareCall(sql, 1003, 1007);
    }

    public CallableStatement prepareCall(String sql, int type, int concurrency) throws SQLException {
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new SQLException(Messages.get("error.generic.nosql"), "HY000");
        }
        JtdsCallableStatement stmt = new JtdsCallableStatement(this, sql, type, concurrency);
        this.addStatement(stmt);
        return stmt;
    }

    public CallableStatement prepareCall(String sql, int type, int concurrency, int holdability) throws SQLException {
        this.checkOpen();
        this.setHoldability(holdability);
        return this.prepareCall(sql, type, concurrency);
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException {
        this.checkOpen();
        return this.prepareStatement(sql, 1003, 1007);
    }

    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new SQLException(Messages.get("error.generic.nosql"), "HY000");
        }
        if (autoGeneratedKeys != 1 && autoGeneratedKeys != 2) {
            throw new SQLException(Messages.get("error.generic.badoption", Integer.toString(autoGeneratedKeys), "executeUpdate"), "HY092");
        }
        JtdsPreparedStatement stmt = new JtdsPreparedStatement(this, sql, 1003, 1007, autoGeneratedKeys == 1);
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int type, int concurrency) throws SQLException {
        this.checkOpen();
        if (sql == null || sql.length() == 0) {
            throw new SQLException(Messages.get("error.generic.nosql"), "HY000");
        }
        JtdsPreparedStatement stmt = new JtdsPreparedStatement(this, sql, type, concurrency, false);
        this.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql, int type, int concurrency, int holdability) throws SQLException {
        this.checkOpen();
        this.setHoldability(holdability);
        return this.prepareStatement(sql, type, concurrency);
    }

    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        if (columnIndexes == null) {
            throw new SQLException(Messages.get("error.generic.nullparam", "prepareStatement"), "HY092");
        }
        if (columnIndexes.length != 1) {
            throw new SQLException(Messages.get("error.generic.needcolindex", "prepareStatement"), "HY092");
        }
        return this.prepareStatement(sql, 1);
    }

    public Savepoint setSavepoint(String name) throws SQLException {
        this.checkOpen();
        this.notImplemented("Connection.setSavepoint(String)");
        return null;
    }

    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        if (columnNames == null) {
            throw new SQLException(Messages.get("error.generic.nullparam", "prepareStatement"), "HY092");
        }
        if (columnNames.length != 1) {
            throw new SQLException(Messages.get("error.generic.needcolname", "prepareStatement"), "HY092");
        }
        return this.prepareStatement(sql, 1);
    }

    void clearSavepoints() {
    }

    protected static class ProcEntry {
        private String name;
        private ColInfo[] colMetaData;
        private ParamInfo[] paramMetaData;

        protected ProcEntry() {
        }

        public final String toString() {
            return this.name;
        }

        static /* synthetic */ ColInfo[] access$102(ProcEntry x0, ColInfo[] x1) {
            x0.colMetaData = x1;
            return x1;
        }

        static /* synthetic */ ParamInfo[] access$202(ProcEntry x0, ParamInfo[] x1) {
            x0.paramMetaData = x1;
            return x1;
        }
    }
}

