/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include <qapplication.h>
#include <qstring.h>
#include <qworkspace.h>
#include "CApplicationWindow.h"
#include "CConsoleWindow.h"
#include "Config.h"
#include "CGeneralConfig.h"
#include "CHistoryView.h"
#include "CMyWindow.h"
#include "CSqlEditor.h"

static void init_globals();
extern void init_img_fname_prompt();
extern void init_icons();

static void init_globals()
{
  Q_CHECK_PTR(g_PasswordDict);
  Q_CHECK_PTR(g_ServersDict);
  Q_CHECK_PTR(g_TranslationsPath);
  Q_CHECK_PTR(g_CurrentLanguage);
  Q_CHECK_PTR(g_CurrentStyle);
  Q_CHECK_PTR(g_SqlEditorStyles);
  Q_CHECK_PTR(g_KeywordDict);
  Q_CHECK_PTR(g_DBKeywordDict);  
  g_SqlEditorStyles->setAutoDelete(true);
  g_KeywordDict->setAutoDelete(true);
  g_DBKeywordDict->setAutoDelete(true);
  g_IconsDict->setAutoDelete(true);
  init_img_fname_prompt();
  init_icons();
}

int main( int argc, char** argv )
{
  QApplication *app = new QApplication(argc, argv);
  int res = 0;  
  CGeneralConfig::Configure(true);
  g_HistoryList->load();
  init_globals();
  setTranslation();
  CConsoleWindow::sqlDebugPanel = new CSqlDebugPanel();
  if (!g_isMDI)
  {
    g_WorkSpace = 0;
    CConsoleWindow *myApplication = new CConsoleWindow();
    app->setMainWidget(myApplication);
    myApplication->setApplicationWidget(true);    
    myShowWindow(myApplication);
    if (g_syntaxHighlight || g_completion)
    {
      if (!CSqlEditor::LoadSyntaxFile())
        myApplication->messagePanel()->Critical(CConsoleWindow::tr("Could not load Syntax File") + ": " + *g_SyntaxFile);
    }    
    res = app->exec();
    delete myApplication;
  }
  else
  {
    CApplicationWindow *myApplication = new CApplicationWindow();
    app->setMainWidget(myApplication);    
    myApplication->consoleWindow = new CConsoleWindow(g_WorkSpace, "CConsoleWindow", CConsoleWindow::WDestructiveClose);   
    if (!myApplication->consoleWindow->loadWindowSettings(true))
      myApplication->consoleWindow->setGeometry(35, 30, 600, 400);    
    myShowWindow(myApplication);
    myShowWindow(myApplication->consoleWindow);
    if (g_syntaxHighlight || g_completion)
    {
      if (!CSqlEditor::LoadSyntaxFile())
        myApplication->consoleWindow->messagePanel()->Critical(CConsoleWindow::tr("Could not load Syntax File") + ": " + *g_SyntaxFile);
    }
    res = app->exec();    
    delete myApplication;    
  }
  delete app;
  return res;
}
