/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CToolBar.h"
#include <qpopmenu.h>
#include "Config.h"
#include "CConfig.h"

privateToolButton::privateToolButton(int result, QWidget * parent, const char * name) : QToolButton(parent, name)
{
  m_result = result;
  connect(this, SIGNAL(clicked()), this, SLOT(Clicked()));  
}

privateToolButton::privateToolButton (QPopupMenu *menu, QWidget * parent, const char * name) : QToolButton(parent, name)
{
  m_popup = menu;
  connect(this, SIGNAL(clicked()), this, SLOT(PopupClicked()));
}

void privateToolButton::PopupClicked()
{
  QPoint p = mapToGlobal(rect().bottomLeft());
  emit buttonClicked(m_popup->exec(p));
}

void privateToolButton::Clicked()
{
  emit buttonClicked(m_result);
}

CToolBar::CToolBar(int type, QString label, QMainWindow * parent, const char* name)
: QToolBar(parent, name)
{  
  m_type = type;
  setLabel(label);
  buttonList.setAutoDelete(true);
  myVisible = true;
  readConfig();
}

void CToolBar::readConfig()
{
  if (!g_saveWorkspace)
    return;
  CConfig *cfg = new CConfig(g_CONFIG_FILE);
  Q_CHECK_PTR(cfg);
  if (cfg->exists())
  {
    cfg->prepare();    
    setVisible(strtobool(cfg->readStringEntry(name(), "true")));
  }
  delete cfg;
}

void CToolBar::privateButtonClicked(int result)
{ 
  emit buttonClicked(m_type, result);  
}

privateToolButton *CToolBar::newButton(int result, const QString & textlabel)
{
  privateToolButton *btn = new privateToolButton(result, this);
  Q_CHECK_PTR(btn);
  btn->setTextLabel(textlabel);  
  connect (btn, SIGNAL(buttonClicked(int)), this, SLOT(privateButtonClicked(int)));  
  buttonList.append(btn);  
  return btn;
}

void CToolBar::addButton(int result, const QIconSet & iconset, const QString & textlabel)
{  
  privateToolButton *btn = newButton(result, textlabel);  
  btn->setIconSet(iconset);  
}

void CToolBar::addButton(int result, const QString & textlabel)
{
  newButton(result, textlabel);
}

void CToolBar::addButton(QPopupMenu * popup, const QIconSet & iconset, const QString & textlabel)
{
  privateToolButton *btn = new privateToolButton(popup, this);  
  Q_CHECK_PTR(btn);
  btn->setTextLabel(textlabel, true);
  btn->setIconSet(iconset);
  connect (btn, SIGNAL(buttonClicked(int)), this, SLOT(privateButtonClicked(int)));
  buttonList.append(btn);  
}

void CToolBar::setVisible(bool v)
{
  if (v)
    show();
  else
    hide();
}

void CToolBar::myShow()
{
  setVisible(!isVisible());
  writeConfig();
}

void CToolBar::myShowWrite()
{
  myShow();
  writeConfig();
}

void CToolBar::insertSeparator()
{
  addSeparator();
}

void CToolBar::setMyVisible(bool v)
{
  myVisible = v;
  setVisible(v);  
}

bool CToolBar::getMyVisible()
{
  return myVisible;
}

void CToolBar::enableAllButtons()
{
  QPtrListIterator<privateToolButton> it(buttonList);
  privateToolButton *b;
  while ( (b = it.current()) != 0 )
  {
    ++it;
    b->setEnabled(true);
  }
}

void CToolBar::setMyEnabled (bool e, int maj, int min)
{  
  if (maj != 0)
  {
    enableAllButtons();
    disableButtons(maj, min);
  }
  setEnabled(e);
}

void CToolBar::writeConfig()
{
  if (!g_saveWorkspace)
    return;
  CConfig *cfg = new CConfig(g_CONFIG_FILE);
  Q_CHECK_PTR(cfg);
  if (cfg->exists())
  {
    cfg->prepare();    
    cfg->writeEntry(name(), booltostr(isVisible()));
    cfg->flush();
  }
  delete cfg;
}

QToolButton * CToolBar::Button(int idx)
{
  return buttonList.at(idx);
}
