/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/
#include "CTextFieldEditor.h"

CTextFieldEditor::CTextFieldEditor(QWidget* parent, QPtrList<CFieldEditorWindow> *editorList, const char* name, CMySQLConnection *m, bool ro)
: CFieldEditorWindow(parent, editorList, name, m, ro)
{ 
  if (!name)
    setName("CTextFieldEditor");
  (void)statusBar();
  editor = new CTextEditor(centralWidget(), "editor", mysql);
  editor->setReadOnly(ro);
  CFieldEditorWindowLayout->addWidget(editor, 0, 0 );
  
  fileOpenAction = new QAction( this, "fileOpenAction" );
  Q_CHECK_PTR(fileOpenAction);
  fileOpenAction->setText(tr("Open", "" ) );
  fileOpenAction->setIconSet( QIconSet(getPixmapIcon("openIcon") ) );
  fileOpenAction->setMenuText(tr("&Open", "" ) );
  fileOpenAction->setAccel( 0 );
  fileOpenAction->setEnabled(!ro);
  
  fileSaveAsAction = new QAction( this, "fileSaveAsAction" );
  Q_CHECK_PTR(fileSaveAsAction);
  fileSaveAsAction->setText(tr("Save As", "" ) );
  fileSaveAsAction->setIconSet( QIconSet(getPixmapIcon("saveIcon") ) );
  fileSaveAsAction->setMenuText(tr("Save &As", "" ) );
  fileSaveAsAction->setAccel( 0 );

  filePrintAction = new QAction( this, "filePrintAction" );
  Q_CHECK_PTR(filePrintAction);
  filePrintAction->setIconSet( QIconSet(getPixmapIcon("printIcon") ) );
  filePrintAction->setText(tr("Print", "" ) );
  filePrintAction->setMenuText(tr("&Print", "" ) );
  filePrintAction->setAccel( 4194384 );

  editUndoAction = new QAction( this, "editUndoAction" );
  Q_CHECK_PTR(editUndoAction);
  editUndoAction->setIconSet( QIconSet(getPixmapIcon("undoIcon") ) );
  editUndoAction->setText(tr("Undo", "" ) );
  editUndoAction->setMenuText(tr("&Undo", "" ) );
  editUndoAction->setAccel( 4194394 );
  editUndoAction->setEnabled(!ro);

  editRedoAction = new QAction( this, "editRedoAction" );
  Q_CHECK_PTR(editRedoAction);
  editRedoAction->setIconSet( QIconSet(getPixmapIcon("redoIcon") ) );
  editRedoAction->setText(tr("Redo", "" ) );
  editRedoAction->setMenuText(tr("&Redo", "" ) );
  editRedoAction->setAccel( 4194393 );
  editRedoAction->setEnabled(!ro);

  editCutAction = new QAction( this, "editCutAction" );
  Q_CHECK_PTR(editCutAction);
  editCutAction->setIconSet( QIconSet(getPixmapIcon("cutIcon") ) );
  editCutAction->setText(tr("Cut", "" ) );
  editCutAction->setMenuText(tr("&Cut", "" ) );
  editCutAction->setAccel( 4194392 );
  editCutAction->setEnabled(!ro);

  editCopyAction = new QAction( this, "editCopyAction" );
  Q_CHECK_PTR(editCopyAction);
  editCopyAction->setIconSet( QIconSet(getPixmapIcon("copyIcon") ) );
  editCopyAction->setText(tr("Copy", "" ) );
  editCopyAction->setMenuText(tr("C&opy", "" ) );
  editCopyAction->setAccel( 4194371 );  

  editPasteAction = new QAction( this, "editPasteAction" );
  Q_CHECK_PTR(editPasteAction);
  editPasteAction->setIconSet( QIconSet(getPixmapIcon("pasteIcon") ) );
  editPasteAction->setText(tr("Paste", "" ) );
  editPasteAction->setMenuText(tr("&Paste", "" ) );
  editPasteAction->setAccel( 4194390 );
  editPasteAction->setEnabled(!ro);

  fileCloseAction = new QAction( this, "fileCloseAction" );
  Q_CHECK_PTR(fileCloseAction);
  fileCloseAction->setText(tr("Close", "" ) );
  fileCloseAction->setMenuText(tr("&Close", "" ) );
  fileCloseAction->setIconSet( QIconSet(getPixmapIcon("closeIcon") ) );
  fileCloseAction->setAccel( 0 );
  
  toolBar = new QToolBar( "", this, DockTop );
  Q_CHECK_PTR(toolBar);
  toolBar->setLabel(tr("Tools") );	
  
  fileOpenAction->addTo( toolBar );
  fileSaveAsAction->addTo( toolBar );
  filePrintAction->addTo( toolBar );
  toolBar->addSeparator();
  editUndoAction->addTo( toolBar );
  editRedoAction->addTo( toolBar );
  editCopyAction->addTo( toolBar );
  editCutAction->addTo( toolBar );
  editPasteAction->addTo( toolBar );
  
  menubar = new QMenuBar( this, "menubar" );
  Q_CHECK_PTR(menubar);
  
  fileMenu = new QPopupMenu( this );
  Q_CHECK_PTR(fileMenu);
  fileOpenAction->addTo( fileMenu );
  fileSaveAsAction->addTo( fileMenu );
  fileMenu->insertSeparator();
  filePrintAction->addTo( fileMenu );
  fileMenu->insertSeparator();
  fileCloseAction->addTo( fileMenu );
  menubar->insertItem(tr("&File", "" ), fileMenu );
  
  editMenu = new QPopupMenu( this );
  Q_CHECK_PTR(editMenu);
  editUndoAction->addTo( editMenu );
  editRedoAction->addTo( editMenu );
  editMenu->insertSeparator();
  editCutAction->addTo( editMenu );
  editCopyAction->addTo( editMenu );
  editPasteAction->addTo( editMenu );
  menubar->insertItem(tr("&Edit", "" ), editMenu );
  init(); 
}

CTextFieldEditor::~CTextFieldEditor()
{  
}

void CTextFieldEditor::SelectionChanged()
{
  bool s = editor->hasSelectedText();
  if (!readOnly)
    editCutAction->setEnabled(s);
  editCopyAction->setEnabled(s);
}

void CTextFieldEditor::setText(const QString &txt)
{
  editor->setText(txt);
}

QString CTextFieldEditor::getText()
{
  return editor->text();
}

void CTextFieldEditor::init()
{
  connect( fileCloseAction, SIGNAL( activated() ), this, SLOT( close() ) );
  connect( editor, SIGNAL( selectionChanged() ), this, SLOT( SelectionChanged() ) );
  connect( editor, SIGNAL( undoAvailable(bool) ), editUndoAction, SLOT( setEnabled(bool) ) );
  connect( editor, SIGNAL( redoAvailable(bool) ), editRedoAction, SLOT( setEnabled(bool) ) );
  connect( editor, SIGNAL( copyAvailable(bool) ), editCopyAction, SLOT( setEnabled(bool) ) );
  connect( editCopyAction, SIGNAL( activated() ), editor, SLOT( copy() ) );   
  connect( fileSaveAsAction, SIGNAL( activated() ), editor, SLOT(save() ) );

  if (!readOnly)
  {
    connect( fileOpenAction, SIGNAL( activated() ), editor, SLOT( openFile() ) );
    connect( editUndoAction, SIGNAL( activated() ), editor, SLOT( undo() ) );
    connect( editRedoAction, SIGNAL( activated() ), editor, SLOT( redo() ) );
    connect( editCutAction, SIGNAL( activated() ), editor, SLOT( cut() ) );
    connect( editPasteAction, SIGNAL( activated() ), editor, SLOT( paste() ) );
  }
    
#ifdef QT_NO_PRINTER
  filePrintAction->setEnabled(false);
#else
  connect( filePrintAction, SIGNAL( activated() ), editor, SLOT( print() ) );
#endif
}

