/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CTextEditor.h"
#include "completion.h"
#include "parenmatcher.h"
#include <qfiledialog.h>

CTextEditor::CTextEditor(QWidget * parent, const char * name, CMySQLConnection *m)
: Editor(parent, name)
{
  mysql = m;
  tmpFileName = QString::null;
}

CTextEditor::~CTextEditor()
{
}

void CTextEditor::save()
{
  saveToFile(tmpFileName, "txt",
	     QObject::tr("Text Files (*.txt);;All Files(*.*)" ),
	     text(), mysql->messagePanel);
}

void CTextEditor::openFile()
{  
  QString fn = QFileDialog::getOpenFileName( QString::null,
					     QObject::tr("Text Files") +
					     " (*.txt);;" + tr("All Files") +
					     " (*.*)", this);
  if ( !fn.isEmpty() )  
    load(fn);  
}

