/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CTableSpecific.h"
#include "CTableProperties.h"
#include <qmessagebox.h>

bool CTableSpecific::inRange(int res)
{
  return ((res >= SQL_ALL_ROWS) && (res <= SQL_QUERY));
}

bool CTableSpecific::renameTable(CMySQLConnection *m, const QString & from, const QString & to)
{    
  CMySQLQuery *qry = new CMySQLQuery(m);
  bool printedMessage = false;
  bool ret = false;
  QString sql;
  bool notnew = ((m->getMySQLServerVersion().major <= 3) && (m->getMySQLServerVersion().minor <= 22));
  if (notnew)
    sql = "ALTER TABLE " + from + " RENAME " + to;
  else
    sql = "RENAME TABLE " + m->Quote(from) + " TO " + m->Quote(to);
  if ((m->isConnected()) && (qry->exec_static(sql, false, &printedMessage)))
  {
    m->PrintError(WARNING, QObject::tr("Successfully Renamed Table") +
		  ": " + from + " -> " + to);
    ret = true;
  }
  else
    if (!printedMessage)
      m->PrintError(CRITICAL);
  delete qry;
  return ret;
}

bool CTableSpecific::newTable(CMySQLConnection *)
{
 // QMessageBox::warning(0,"New Table", "New Table");
  return false;
}

bool CTableSpecific::importTable(CMySQLConnection *)
{
 // QMessageBox::warning(0,"Import Table", "Import Table");
  return false;
}

bool CTableSpecific::exportTable(CMySQLConnection *,
				 const QString & /*tableName*/)
{
//  QMessageBox::warning(0,"Export Table", "Export Table: " + tableName);
  return false;
}

bool CTableSpecific::deleteTable(CMySQLConnection *m,
				 const QString & tableName)
{
  if (g_confirmCritical)
    if ((QMessageBox::information(0, QObject::tr("Confirm Delete Table"), 
      QObject::tr("Are you sure you want to Delete Table") + ": \"" + tableName + "\" ?",
      QObject::tr("&Yes"), QObject::tr("&No")) != 0))
      return false;
  
  CMySQLQuery qry(m);
  bool printedMessage = false;
  QString sql = "DROP TABLE IF EXISTS " + m->Quote(tableName);
  if ((m->isConnected()) && (qry.exec_static(sql, false, &printedMessage)))
  {
    m->PrintError(WARNING,
		  QObject::tr("Successfully Deleted Table") + ": "
		  + tableName);
    return true;
  }
  else
    if (!printedMessage)
      m->PrintError(CRITICAL);  
  return false;
}

bool CTableSpecific::editTable(CMySQLConnection *, const QString & /*tableName*/)
{
//  QMessageBox::warning(0,"Edit Table", "Edit Table: " + tableName);
  return false;
}

bool CTableSpecific::emptyTable(CMySQLConnection *m, const QString & tableName)
{
  if ((QMessageBox::information(0, QObject::tr("Confirm Empty Table"), 
    QObject::tr("Are you sure you want to Empty Table") + ": \"" + tableName + "\" ?",
    QObject::tr("&Yes"), QObject::tr("&No")) == 0))
  {    
    CMySQLQuery qry(m);
    bool printedMessage = false;
    QString sql;
    bool notnew = ((m->getMySQLServerVersion().major <= 3) && (m->getMySQLServerVersion().minor <= 22));
    if (notnew)
      sql = "DELETE FROM " + tableName;
    else
      sql = "TRUNCATE TABLE " + m->Quote(tableName);    
    if ((m->isConnected()) && (qry.exec_static(sql, false, &printedMessage)))
    {
      m->PrintError(WARNING, QObject::tr("Successfully Emptied Table") +
		    ": " + tableName);
      return true;
    }
    else
      if (!printedMessage)
        m->PrintError(CRITICAL);
  }    
  return false;
}

void CTableSpecific::tableProperties(CMySQLConnection *m, const QString & tableName)
{
  CTableProperties *w = new CTableProperties(m , tableName, g_WorkSpace, "TableProperties");
  Q_CHECK_PTR(w);
  w->setFocus();
  w->raise();
  myShowWindow(w);  
}

void CTableSpecific::QueryWindow(CMySQLConnection *m, const QString & tableName, int q, int serverid)
{
  int limit = 0;
  if (q == SQL_LIMIT)
  {
    bool ok = false;
    // TODO: fix magic numbers
    limit = QInputDialog::getInteger(
      QObject::tr("Number of Rows"),
      QObject::tr("Maximum number of Rows to fetch") + ":",1000,0, 2147483600, 1, &ok, 0);							
    if (!ok)
      return;		
  }
  int flags = ((q != SQL_QUERY) ? RESULTS_PANEL : SQL_PANEL);  
  CQueryWindow *w = new CQueryWindow(g_WorkSpace, m, q, tableName, limit, flags, serverid);
  Q_CHECK_PTR(w);
  w->setFocus();
  w->raise();  
  myShowWindow(w);
  if (q != SQL_QUERY)
    w->ExecuteQuery();  
}

void CTableSpecific::processMenu(CMySQLConnection *m, int res, const QString & tableName, int serverid)
{	
  if (inRange(res))
    QueryWindow(m, tableName, res, serverid);
}

QPopupMenu * CTableSpecific::openTableMenu()
{  
  QPopupMenu *p_openTableMenu = new QPopupMenu();
  Q_CHECK_PTR(p_openTableMenu);
  p_openTableMenu->insertItem(QObject::tr("Return all rows"), SQL_ALL_ROWS);
  p_openTableMenu->insertItem(QObject::tr("Return Limit"), SQL_LIMIT);
  p_openTableMenu->insertItem(getPixmapIcon("sqlIcon"), QObject::tr("Query"), SQL_QUERY);
  return p_openTableMenu;
}

