/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CTableProperties.h"

privateTableProperties::privateTableProperties(QWidget* parent, CMySQLConnection *m, const QString &tablename)
: CListViewProperties(parent, m, "privateTableProperties"), tableName(tablename)
{
  details->addColumn(tr("Property" ) );
  details->addColumn(tr("Value" ) );
  details->header()->setClickEnabled(false, 1);
  setSaveTitle(tr("Table Properties") + ": " + tableName);
  refresh();
}

void privateTableProperties::refresh()
{    
  title->setText(" " + tr("Table") + ": " + tableName);  
  CListViewProperties::refresh();
}

void privateTableProperties::insertData()
{
  CMySQLQuery query(mysql);
  if (query.exec("SHOW TABLE STATUS LIKE '" + tableName + "'", false, false))
  {
    query.next();
    for (unsigned int i = 0; i < query.numFields(); i++)      
        insertItem(query.Fields[i].name, query.Row(i));    
  }
}

CTableProperties::CTableProperties(CMySQLConnection *m , const QString &tablename, QWidget* parent, const char* name)
:CMyWindow( parent, name, WDestructiveClose, !g_isMDI)
{
  if ( !name )
	  setName( "CTableProperties");  
  setIcon(getPixmapIcon("applicationIcon"));  
  setCaption(tr("Table Properties"));
  Form1Layout = new QVBoxLayout( this, 2, 2, "Form1Layout");
  Q_CHECK_PTR(Form1Layout);
  
  tableProperties = new privateTableProperties(this, m, tablename);  
  Q_CHECK_PTR(tableProperties);
  Form1Layout->addWidget( tableProperties );  
  Layout1 = new QHBoxLayout( 0, 0, 6, "Layout1");
  Q_CHECK_PTR(Layout1);
  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
  Q_CHECK_PTR(spacer);
  Layout1->addItem( spacer );
  
  m_pClosePushButton = new QPushButton( this, "m_pClosePushButton" );
  Q_CHECK_PTR(m_pClosePushButton);
  m_pClosePushButton->setMinimumSize( QSize( 60, 0 ) );
  m_pClosePushButton->setMaximumSize( QSize( 60, 32767 ) );
  setMinimumHeight(160);
  m_pClosePushButton->setText(tr("&Close" ) );
  Layout1->addWidget( m_pClosePushButton );
  Form1Layout->addLayout( Layout1 );  
  init();
  myResize( 300, 350 );
  autoPlace();
}

CTableProperties::~CTableProperties()
{  
}

void CTableProperties::init()
{  
  QWhatsThis::add( (QWidget *) m_pClosePushButton,tr("Close this Dialog."));
  connect(m_pClosePushButton, SIGNAL(clicked()), this, SLOT(close()));  
}



