/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

/*
  The records for this table are inserted & handled by CTableGroupItem::refresh()
*/

#include "CShowTableGroupProperties.h"
#include "CTableItem.h"
#include "CTableTools.h"
#include "CTableSpecific.h"
#include "CDatabaseTreeItem.h"

CShowTableGroupProperties::CShowTableGroupProperties(QWidget * parent, CMySQLConnection *conn, CDatabaseTreeItem *parentitem, int serverid) 
: CSqlTable(parent, conn), serverID(serverid)
{
  setLeftMargin(0);
  setName("CShowTableGroupProperties");
  verticalHeader()->hide();
  setReadOnly(true);
  setFocusStyle(QTable::FollowStyle);
  setSelectionMode(QTable::SingleRow);	
  widgetStack = (QWidgetStack *) parent;
  parentItem = parentitem;
}

void CShowTableGroupProperties::processMenu(int res, int row, int)
{ 
  int r = f_processMenu(res, parentItem, widgetStack, m_pDatabaseConnection, text(row,0), serverID);  
  if (r != 0)    
  switch (r)  
  {
    case MENU_RENAME:
      {
        bool ok = false;
        QString t = QInputDialog::getText(
          tr("Rename Table"), tr("Rename Table") + " \"" + text(row,0) + "\" " + tr("to") + ":",
          QLineEdit::Normal, QString::null, &ok, this);
        if ( ok && !t.isEmpty() )
          if (CTableSpecific::renameTable(m_pDatabaseConnection, text(row,0), t))
          {
            setText(row,0,t);
            parentItem->refresh();
          }
        break;
      }
      case MENU_REFRESH:
        {          
          parentItem->refresh();
          break;
        }
  }  
}

int CShowTableGroupProperties::displayMenu(const QPoint &pos)
{  
  return f_displayMenu(pos, getDatabaseConnection(), (numRows() <= 0));  //Friend member defined in CTableItem  
}

void CShowTableGroupProperties::DoubleClicked (int row, int, int button, const QPoint &)
{	
  if ((row > -1) && (button == 1))
    CTableSpecific::processMenu(m_pDatabaseConnection, SQL_ALL_ROWS, text(row,0), serverID);
}

