/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CSharedMenus.h"
#include "CConfig.h"
#include <qmessagebox.h>

CConsoleMenu::CConsoleMenu(QWidget * parent, QMenuBar *menuBar, const char * name)
:QPopupMenu(parent, name)
{  
  m_pConsoleExitAction = new QAction(parent, "ConsoleExitAction");
  Q_CHECK_PTR(m_pConsoleExitAction);
  m_pConsoleExitAction->setText(tr("Exit", ""));
  m_pConsoleExitAction->setMenuText(tr("&Exit", ""));
  m_pConsoleExitAction->setIconSet(QIconSet(getPixmapIcon("exitIcon")));
  m_pConsoleExitAction->setAccel(0);
    
  m_pConsoleExitAction->addTo(this);

  menuBar->insertItem( tr( "&Console", "" ), this);
  connect(m_pConsoleExitAction, SIGNAL(activated()), parent, SLOT(close()));
}


CHelpMenu::CHelpMenu(QWidget * parent, QMenuBar *menuBar, const char * name)
:QPopupMenu(parent, name)
{  
  m_pHelpContentsAction = new QAction(parent, "HelpContentsAction");
  Q_CHECK_PTR(m_pHelpContentsAction);
  m_pHelpContentsAction->setText(tr("Contents", ""));
  m_pHelpContentsAction->setMenuText(tr("&Contents", ""));
  m_pHelpContentsAction->setAccel(0);
  //TODO Remove the below line when the help file is implemented
  m_pHelpContentsAction->setEnabled(false);

  m_pHelpWhatIsThisAction = new QAction(parent, "HelpWhatIsThisAction");
  Q_CHECK_PTR(m_pHelpWhatIsThisAction);
  m_pHelpWhatIsThisAction->setText(tr("What's This ?", ""));
  m_pHelpWhatIsThisAction->setMenuText(tr("&What's This ?", ""));
  m_pHelpWhatIsThisAction->setIconSet(QIconSet(getPixmapIcon("contextHelpIcon")));
  m_pHelpWhatIsThisAction->setAccel(0);

  m_pHelpCreditsAction = new QAction(parent, "HelpCreditsAction");
  Q_CHECK_PTR(m_pHelpCreditsAction);
  m_pHelpCreditsAction->setText(tr("Credits"));
  m_pHelpCreditsAction->setMenuText(tr("&Credits"));
  m_pHelpCreditsAction->setAccel(0);

  m_pHelpAboutAction = new QAction(parent, "HelpAboutAction");
  Q_CHECK_PTR(m_pHelpAboutAction);
  m_pHelpAboutAction->setText(tr("About") + " " + QString(CODENAME));
  m_pHelpAboutAction->setMenuText(tr("&About") + " " + QString(CODENAME));
  m_pHelpAboutAction->setIconSet(QIconSet(getPixmapIcon("aboutIcon")));
  m_pHelpAboutAction->setAccel(0);
    
  m_pHelpContentsAction->addTo(this);
  m_pHelpWhatIsThisAction->addTo(this);
  insertSeparator();
  m_pHelpCreditsAction->addTo(this);
  m_pHelpAboutAction->addTo(this);

  menuBar->insertItem( tr( "&Help", "" ), this);
  connect(m_pHelpAboutAction, SIGNAL(activated()), this, SLOT(AboutAction()));
  connect(m_pHelpCreditsAction, SIGNAL(activated()), this, SLOT(CreditsAction()));
  connect(m_pHelpWhatIsThisAction, SIGNAL(activated()), parent, SLOT(whatsThis()));
  connect(m_pHelpContentsAction, SIGNAL(activated()), this, SLOT(ContentsAction()));  
}

void CHelpMenu::ContentsAction()
{
  QMessageBox::information(0, "Missing", "CHelpMenu::ContentsAction(): Not implemented yet!" );
}

void CHelpMenu::AboutAction()
{
  CAboutBox aboutBox;
  aboutBox.exec();
}

void CHelpMenu::CreditsAction()
{
  CCreditsBox creditsBox;
  creditsBox.exec();
}


COptionsMenu::COptionsMenu(QWidget * parent, QMenuBar *menuBar, const char * name)
:QPopupMenu(parent, name)
{  
  m_pOptionsMDIAction = new QAction(parent, "OptionsMDIAction", true);
  Q_CHECK_PTR(m_pOptionsMDIAction);
  m_pOptionsMDIAction->setMenuText(tr("&MDI", ""));  
  m_pOptionsMDIAction->setAccel(0);  
  m_pOptionsMDIAction->setOn(g_isMDI);

  m_pOptionsFontsAction = new QAction(parent, "OptionsFontsAction");
  Q_CHECK_PTR(m_pOptionsFontsAction);
  m_pOptionsFontsAction->setMenuText(tr("&Font", ""));
  m_pOptionsFontsAction->setIconSet(QIconSet(getPixmapIcon("fontsIcon")));
  m_pOptionsFontsAction->setAccel(0);

  m_pOptionsPrinterFontAction = new QAction(parent, "OptionsPrinterFontAction");
  Q_CHECK_PTR(m_pOptionsPrinterFontAction);
  m_pOptionsPrinterFontAction->setMenuText(tr("&Printer Font", ""));
  m_pOptionsPrinterFontAction->setIconSet(QIconSet(getPixmapIcon("printerFontIcon")));
  m_pOptionsPrinterFontAction->setAccel(0);

  m_pOptionsGeneralAction = new QAction(parent, "OptionsGeneralAction");
  Q_CHECK_PTR(m_pOptionsGeneralAction);
  m_pOptionsGeneralAction->setMenuText(tr("&General", ""));
  m_pOptionsGeneralAction->setIconSet(QIconSet(getPixmapIcon("hammerIcon")));
  m_pOptionsGeneralAction->setAccel(0);

  m_pOptionsMDIAction->addTo( this );

#ifndef QT_NO_STYLE  
  m_pThemesMenu = new QPopupMenu(this);
  Q_CHECK_PTR(m_pThemesMenu);
  m_pThemesMenu->setCheckable(true);
  insertItem(getPixmapIcon("stylesIcon"), tr("&Themes"), m_pThemesMenu);  
  connect(m_pThemesMenu, SIGNAL(aboutToShow()), this, SLOT(themesMenuAboutToShow()));
#endif

  m_pOptionsFontsAction->addTo( this );
  m_pOptionsPrinterFontAction->addTo( this );

  insertSeparator();

  m_pOptionsGeneralAction->addTo( this );

  menuBar->insertItem(tr("&Options"), this);
  connect(m_pOptionsMDIAction, SIGNAL(activated()), this, SLOT(MDIAction()));
  connect(m_pOptionsFontsAction, SIGNAL(activated()), this, SLOT(FontsAction()));
  connect(m_pOptionsPrinterFontAction, SIGNAL(activated()), this, SLOT(PrinterFontAction()));  
  connect(m_pOptionsGeneralAction, SIGNAL(activated()), this, SLOT(GeneralAction()));
}

void COptionsMenu::MDIAction()
{  
  CConfig *cfg = new CConfig(g_CONFIG_FILE);
  Q_CHECK_PTR(cfg);
  cfg->prepare();
  cfg->writeEntry("MDI", booltostr(m_pOptionsMDIAction->isOn()));
  cfg->flush();
  if (g_isMDI != m_pOptionsMDIAction->isOn())
    QMessageBox::information(0, tr("Restart"), tr("You will need to restart MyCC before you notice your changes."));
  delete cfg;
}

void COptionsMenu::themesMenuAboutToShow()
{
#ifndef QT_NO_STYLE
  m_pThemesMenu->clear();
  QStringList list = QStyleFactory::keys();
  list.sort();
  int i = 0;
  for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
  {
    int id = m_pThemesMenu->insertItem(*it, this, SLOT(styleSelected(int)));
    m_pThemesMenu->setItemChecked(id, *g_CurrentStyle == *it);
    i++;
  }
#endif
}

void COptionsMenu::styleSelected(int id)
{
#ifndef QT_NO_STYLE  
  *g_CurrentStyle = m_pThemesMenu->text(id);
  CConfig *cfg = new CConfig(g_CONFIG_FILE);
  Q_CHECK_PTR(cfg);
  cfg->prepare();
  cfg->writeEntry("Style", *g_CurrentStyle);
  cfg->flush();  
  qApp->setStyle(*g_CurrentStyle);
  CGeneralConfig::setStylePalette(*g_CurrentStyle);
  QFont font;
  font.fromString(cfg->readStringEntry("Font", QFont().toString()));
  qApp->setFont((font), true);
  delete cfg;
#endif
}

void COptionsMenu::FontsAction()
{
  bool ok;
  QFont font = QFontDialog::getFont( &ok, qApp->font());  
  if (ok)
  {
    qApp->setFont(font, true);
    CConfig *cfg = new CConfig(g_CONFIG_FILE);
    Q_CHECK_PTR(cfg);
    cfg->prepare();
    cfg->writeEntry("Font", font.toString());
    cfg->flush();
    delete cfg;    
  }
}

void COptionsMenu::PrinterFontAction()
{
  bool ok;
  QFont font = QFontDialog::getFont( &ok, g_printerFont);
  if (ok)
  {    
    CConfig *cfg = new CConfig(g_CONFIG_FILE);
    Q_CHECK_PTR(cfg);
    cfg->prepare();
    cfg->writeEntry("Printer Font", font.toString());
    g_printerFont = font;
    cfg->flush();
    delete cfg;    
  }
}

void COptionsMenu::GeneralAction()
{
  CGeneralConfig *config = new CGeneralConfig((QWidget*)g_WorkSpace);
  Q_CHECK_PTR(config);
  myShowWindow(config);
}

