/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CServerItem.h"
#include "CDatabaseGroupItem.h"
#include "CDatabaseTree.h"
#include "CServerAdministrationItem.h"
#include "CUserAdminItem.h"
#include "syntaxhighliter_sql.h"
#include "CConsoleWindow.h"
#include "CTableSpecific.h"
#include <qmessagebox.h>

CServerItem::CServerItem(CMyWindow *consoleWindow, int serverid, CDatabaseTree * parent, QString connectionName, bool isconnected, QWidgetStack *w)
: CDatabaseTreeItem(parent)
{	
  serverID = serverid;
  ConsoleWindow = consoleWindow;
  setType(SERVER_ITEM);
  setName("CServerItem");
  m_isConnected = false;  
  setText(0,connectionName);
  if (g_ServersDict->find(serverid) == NULL)
  {
    if (g_ServersDict->size() <= g_ServersDict->count() + 1)
      g_ServersDict->resize(g_ServersDict->count() + 1);
    g_ServersDict->insert(serverid, new QString(connectionName));
  }
  setOpen(true);
  m_pMySQLServer = new CMySQLConnection(connectionName, ConsoleWindow->messagePanel());
  Q_CHECK_PTR(m_pMySQLServer);
  deletedServerProperties = false;
  widgetStack = w;
  init_item();
  myParent = parent;
  setConnected(isconnected);
}

CServerItem::~CServerItem()
{
#ifdef DEBUG
  qDebug ("~CServerItem()");
#endif
  delete m_pMySQLServer;
  if (!deletedServerProperties)
  {
    widgetStack->removeWidget(serverProperties);
    delete serverProperties;
  }  
}

void CServerItem::clicked()
{
  if (isBusy)
    return;
  widgetStack->raiseWidget(widgetID);
}

void CServerItem::init_item()
{
  isBusy = false;
  serverProperties = new CShowServerProperties(widgetStack, m_pMySQLServer);
  Q_CHECK_PTR(serverProperties);
  widgetID = getWidgetID();
  widgetStack->addWidget (serverProperties, widgetID);
  m_pMySQLServer->signalConnect(SIGNAL(statuschanged()), serverProperties, SLOT(refresh()));
}

void CServerItem::setConnected(bool connected)
{
  if (isBusy)
    return;
  isBusy = true;
  listView()->setCursor(Qt::waitCursor);
  m_isConnected = m_pMySQLServer->setConnected(connected, "", true);  
  if (!m_isConnected)
  { 
    deleteChilds();
    if ((m_pMySQLServer->hasCompletion()) && (((CConsoleWindow *) ConsoleWindow)->getCanClose() == false))
      if (g_DBKeywordDict->find(serverID) != NULL)
        g_DBKeywordDict->remove(serverID);    
  }
  else
  {    
    if (m_pMySQLServer->hasCompletion())
    {
      if (g_DBKeywordDict->find(serverID) == NULL)      
        g_DBKeywordDict->insert(serverID, new DBKeyWord());
    }  
    new CDatabaseGroupItem(ConsoleWindow, serverID, this, false, widgetStack);
  	new CUserAdminItem(ConsoleWindow, this, widgetStack);
    new CServerAdministrationItem(ConsoleWindow, this, widgetStack);
    setOpen(true); 
  } 
  setPixmap(0, getPixmapIcon(!m_isConnected ? "serverDisconnectedIcon" : "serverConnectedIcon"));
  listView()->setCursor(Qt::ArrowCursor);
  isBusy = false;
}


void CServerItem::processMenu(int res)
{
  if (isBusy)
    return;
  switch (res)
  {
		case MENU_CONNECT: setConnected(true);
      break;
      
    case MENU_DISCONNECT: setConnected(false);
      break;
      
    case MENU_EDIT: {
      CConnectionDialog* pConnectionDialog = new CConnectionDialog(ConsoleWindow, (QWidget *)g_WorkSpace, "CConnectionDialog", m_pMySQLServer, this, serverID);
      pConnectionDialog->connect(pConnectionDialog, SIGNAL(connectionRenamed(CDatabaseTreeItem*, const QString &)), myParent, SLOT(ConnectionRenamed(CDatabaseTreeItem *, const QString &)));
      myShowWindow(pConnectionDialog);      
      break;
                    }
    case MENU_QUERY: CTableSpecific::QueryWindow(m_pMySQLServer, "", SQL_QUERY, serverID);
      break;
    case MENU_DELETE: {
      if (g_confirmCritical)
        if ((QMessageBox::information(0,
				      QObject::tr("Confirm Delete Server"),
          QObject::tr("Are you sure you want to Delete Server") +
				      ": \"" + text(0) + "\"?",
          QObject::tr("&Yes"),QObject::tr("&No")) != 0))
          return;
      removeServer();        
      ((CDatabaseTree *)listView())->hideItemToolbars();        
      ((CDatabaseTree *)listView())->refreshServers();        
      break;
                      }
  }
}

void CServerItem::removeServer()
{
  if (isBusy)
    return;
  isBusy = true;
  QString tmpname = text(0);  
  CConfig conn(tmpname, g_CONNECTION_PATH);
  if (!deletedServerProperties)
  { 
    widgetStack->removeWidget(serverProperties);
    delete serverProperties;    
    deletedServerProperties = true;
    QString *serverName = g_ServersDict->find(getServerID());    
    if (serverName != NULL)    
      delete serverName;    
    g_ServersDict->remove (getServerID());    
  }  
  setConnected(false);  
  conn.remove();
  setVisible(false);
  isBusy = false;
}

int CServerItem::displayMenu(const QPoint &pos)
{
  if (isBusy)
    return -1;
  QPopupMenu *p_itemMenu = new QPopupMenu();
  if (!m_isConnected)  
    p_itemMenu->insertItem(getPixmapIcon("serverConnectedIcon"), QObject::tr("Connect"), MENU_CONNECT);  
  else    
    p_itemMenu->insertItem(getPixmapIcon("serverDisconnectedIcon"), QObject::tr("Disconnect"), MENU_DISCONNECT);  
  
  p_itemMenu->insertSeparator();  
  p_itemMenu->insertItem(getPixmapIcon("sqlIcon"), QObject::tr("Query"), MENU_QUERY);  
  p_itemMenu->setItemEnabled(MENU_QUERY, m_isConnected);

  p_itemMenu->insertSeparator();  
  p_itemMenu->insertItem(getPixmapIcon("editIcon"), QObject::tr("Edit"), MENU_EDIT);  
  p_itemMenu->insertItem(getPixmapIcon("deleteIcon"), QObject::tr("Delete"), MENU_DELETE);

  p_itemMenu->insertSeparator();  
  p_itemMenu->insertItem(getPixmapIcon("newWindowIcon"), QObject::tr("New Window from Here"), NEW_WINDOW_FROM_HERE);

  int res = p_itemMenu->exec(pos);
  delete p_itemMenu;
  return res;
}

void CServerItem::doubleClicked()
{  
  if ((!m_isConnected) && (!isBusy))
    setConnected(true);	
}

CServerItemToolbar::CServerItemToolbar(QMainWindow * parent)
 :CToolBar(SERVER_ITEM, tr("Server"), parent, "Server Toolbar")
{  
  addButton(MENU_CONNECT, getPixmapIcon("serverConnectedIcon"), tr("Connect"));
  addButton(MENU_DISCONNECT, getPixmapIcon("serverDisconnectedIcon"), tr("Disconnect"));
  insertSeparator();
  addButton(MENU_QUERY, getPixmapIcon("sqlIcon"), tr("Query"));
  insertSeparator();
  addButton(MENU_EDIT, getPixmapIcon("editIcon"), tr("Edit Connection"));
  addButton(MENU_DELETE, getPixmapIcon("deleteIcon"), tr("Delete Connection"));
  insertSeparator();
  addButton(NEW_WINDOW_FROM_HERE, getPixmapIcon("newWindowIcon"), tr("Open in New Window"));  
}

void CServerItemToolbar::setConnectedToolbar(bool connected)
{  
  Button(0)->setEnabled(!connected);
  Button(1)->setEnabled(connected);
  Button(2)->setEnabled(connected);
}
