/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CDatabaseTreeItem.h"
#include "CMySQLConnection.h"

QString CDatabaseTreeItem::m_className;

CDatabaseTreeItem::CDatabaseTreeItem (QListView * parent): QListViewItem(parent)
{   
  init();
}

CDatabaseTreeItem::CDatabaseTreeItem (CDatabaseTreeItem * parent) : QListViewItem(parent)
{ 
  init();  
}

void CDatabaseTreeItem::init()
{
  m_pMySQLServer = 0;
  m_pMySQLDatabase = 0;
  setDragEnabled (true);
}

void CDatabaseTreeItem::setType(int type)
{ 
  m_itemType = type; 
}

int CDatabaseTreeItem::getType()
{
  return m_itemType;
}

void CDatabaseTreeItem::setCurrentText(const QString &t)
{
  currentText = t;
}

void CDatabaseTreeItem::setName(const char *name)
{
  m_className = name;
}

const char* CDatabaseTreeItem::getName()
{
  return m_className.latin1();
}

QString CDatabaseTreeItem::getCurrentText()
{
  return currentText;
}

int CDatabaseTreeItem::displayMenu(const QPoint &)
{
  return -1;
}

bool CDatabaseTreeItem::isConnected()
{
  return false;
}

QString CDatabaseTreeItem::getTitle()
{
  return this->text(0);
}

int CDatabaseTreeItem::getWidgetID()
{
  return g_widgetID++;
}

void CDatabaseTreeItem::getServerVersion(int &maj, int &min)
{
  qDebug ("----->CDatabaseTreeItem::getServerVersion - enter");
  if ((m_pMySQLDatabase != 0) && (m_pMySQLDatabase->isConnected()))
  {
    maj = m_pMySQLDatabase->getMySQLServerVersion().major;
    min = m_pMySQLDatabase->getMySQLServerVersion().minor;
  }
  else
    if ((m_pMySQLServer != 0) && (m_pMySQLServer->isConnected()))
    {
      maj = m_pMySQLServer->getMySQLServerVersion().major;
      min = m_pMySQLServer->getMySQLServerVersion().minor;
    }
    else
    {
      maj = 0;
      min = 0;
    }  
}

void CDatabaseTreeItem::deleteChilds()
{  
  QListViewItemIterator c( firstChild() );
  for ( ; c.current(); ++c )
  {    
    if (c.current()->parent() != this->parent())
    {   
      QListViewItem *p = c.current();     
      takeItem(p);      
      delete(p);
      p = NULL;
      if (!this->nextSibling() && (((CDatabaseTreeItem *)this)->getType() != SERVER_ITEM))
        break;
    }
    else
      break;
  }
}
  
void CDatabaseTreeItem::itemDrag(const char *t) 
{
  QDragObject *d = new QTextDrag(QString(t) + "\\" + text(0));
  Q_CHECK_PTR(d);
  d->dragCopy();   
}


