/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CCreditsBox.h"
#include <qlabel.h>
#include <qwhatsthis.h>

p_infoWidget::p_infoWidget( QWidget* parent,  const char* name, WFlags fl )
: QWidget( parent, name, fl )
{
  if ( !name )
    setName( "p_infoWidget" );
  p_infoWidgetLayout = new QGridLayout( this, 1, 1, 1, 1, "p_infoWidgetLayout"); 
  
  TextLabel3_2 = new QLabel( this, "TextLabel3_2" );
  TextLabel3_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)2, 0, 0, TextLabel3_2->sizePolicy().hasHeightForWidth() ) );
  TextLabel3_2->setFrameShape( QLabel::Panel );
  TextLabel3_2->setFrameShadow( QLabel::Sunken );
  TextLabel3_2->setText(tr(" Volker Hilsheimer<br>\n"
    "Trolltech Support Team<br>\n"
    "Matt Wagner<br>\n"
    "Jeremy Cole<br>\n"
    "Jani Tolonen<br>\n"
    "Tom Basil<br>" ) );
  TextLabel3_2->setAlignment( int( QLabel::AlignTop ) );
  QWhatsThis::add( TextLabel3_2,tr("People who contributed indirectly to this development." ) );
  
  p_infoWidgetLayout->addWidget( TextLabel3_2, 4, 0 );
  
  TextLabel2_2 = new QLabel( this, "TextLabel2_2" );
  TextLabel2_2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, TextLabel2_2->sizePolicy().hasHeightForWidth() ) );
  QFont TextLabel2_2_font(  TextLabel2_2->font() );
  TextLabel2_2_font.setBold(true);
  TextLabel2_2->setFont( TextLabel2_2_font ); 
  TextLabel2_2->setText(tr("Special Thanks To:" ) );
  
  p_infoWidgetLayout->addWidget( TextLabel2_2, 3, 0 );
  
  TextLabel2 = new QLabel( this, "TextLabel2" );
  TextLabel2->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, 0, 0, TextLabel2->sizePolicy().hasHeightForWidth() ) );
  QFont TextLabel2_font(  TextLabel2->font() );
  TextLabel2_font.setBold(true);
  TextLabel2->setFont( TextLabel2_font ); 
  TextLabel2->setText( "\n" +tr("Contributors:" ) );
  
  p_infoWidgetLayout->addWidget( TextLabel2, 0, 0 );
  
  TextLabel3 = new QLabel( this, "TextLabel3" );
  TextLabel3->setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)7, (QSizePolicy::SizeType)0, 0, 0, TextLabel3->sizePolicy().hasHeightForWidth() ) );
  TextLabel3->setFrameShape( QLabel::Panel );
  TextLabel3->setFrameShadow( QLabel::Sunken );
  TextLabel3->setText(tr(" <b>Jorge del Conde</b> [jorge@mysql.com]<br>\n"
    "<b>Sasha Pachev</b> [sasha@mysql.com]<br>\n"
    "<b>Michael Widenius</b> [monty@mysql.com]<br>\n"
    "<b>Reginald Stadlbauer</b> [reggie@trolltech.com]<br>\n"
    "<b>Adam Hooper</b> [adamh@densi.com]" ) );

  TextLabel3->setAlignment( int( QLabel::AlignTop ) );
  QWhatsThis::add( TextLabel3,tr("People who contributed directly to this development." ) );
  
  p_infoWidgetLayout->addWidget( TextLabel3, 1, 0 );
  QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Fixed );
  p_infoWidgetLayout->addItem( spacer, 2, 0 );
}

p_infoWidget::~p_infoWidget()
{
}

CCreditsBox::CCreditsBox( QWidget* parent,  const char* name, bool modal, WFlags fl )
: CInfoDialog( parent, name, modal, fl )
{  
  if ( !name )
    setName( "CCreditsBox" );
  setCaption(tr("Credits"));
  infoWidget = new p_infoWidget(this, "p_infoWidget");
  addMainWidget(infoWidget);
}

CCreditsBox::~CCreditsBox()
{
}
