/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CConsoleWindow.h"
#include "CDatabaseTreeItem.h"
#include <qmessagebox.h>

CSqlDebugPanel * CConsoleWindow::sqlDebugPanel;

CConsoleWindow::CConsoleWindow(QWidget* parent,  const char* name, WFlags fl, CDatabaseTreeItem *itemRoot, bool destroy)
: CMyWindow(parent, name, fl, destroy, true)
{
  (void)statusBar();
  canClose = (itemRoot != 0);

  if (!canClose)
    p_messageWindow->addPanel(sqlDebugPanel);

  if ((!g_isMDI) || (canClose))
    setName("CConsoleWindow2");
  else
    if (!name)
      setName("CConsoleWindow");
  if ((!g_isMDI) && (!destroy))
    new CConsoleMenu(this, menuBar(), "ConsoleMenu");  
  setIcon(getPixmapIcon("applicationIcon"));
  setCentralWidget( new QWidget( this, "qt_central_widget"));
  CConsoleWindowLayout = new QVBoxLayout(centralWidget(), 2, 2, "CConsoleLayout");
  Q_CHECK_PTR(CConsoleWindowLayout);
  m_pConsoleStack = new QWidgetStack(centralWidget(), "Console Stack");
  Q_CHECK_PTR(m_pConsoleStack);
  m_pConsoleStack->setFrameShape(QFrame::StyledPanel);
  m_pConsoleStack->setFrameShadow(QFrame::Sunken);
  m_pConsoleStack->setLineWidth(1);
  m_pConsoleStack->setMargin(0);
  defaultWidget = new QWidget(m_pConsoleStack);
  Q_CHECK_PTR(defaultWidget);
  m_pConsoleStack->addWidget (defaultWidget, 0);
  CConsoleWindowLayout->addWidget(m_pConsoleStack);
  treePanel = new privateTreePanel(QDockWindow::InDock, 0, (((g_isMDI) && (!canClose)) ? "privateTreePanel" : "privateTreePanel2"));
  Q_CHECK_PTR(treePanel);
  m_pDatabaseTree = new CDatabaseTree(this, treePanel, (!g_isMDI && !destroy),  "CDatabaseTree", 0);
  Q_CHECK_PTR(m_pDatabaseTree);
  m_pDatabaseTree->setMinimumSize(50, 50);
  m_pDatabaseTree->widgetStack = m_pConsoleStack;
  treePanel->setWidget(m_pDatabaseTree);
  if ((!g_isMDI) && (!destroy))
    new COptionsMenu(this, menuBar(), "OptionsMenu");
  if (!canClose)
    new CHelpMenu(this, menuBar(), "HelpMenu");
  setMinimumWidth(170);
  setMinimumHeight(185);
  setCaption(tr("Console Manager"));
  setDockEnabled(treePanel, Qt::DockLeft, true);
  addDockWindow(treePanel, DockLeft);
  if ((g_isMDI) && (!canClose))
  {
    ((CMyWindow *)qApp->mainWidget())->setDockEnabled(treePanel, Qt::DockLeft, true);
    ((CMyWindow *)qApp->mainWidget())->setDockEnabled(p_messageWindow, Qt::DockBottom, true);
  }
  if ((!g_isMDI) && (!destroy))
  {  
    if (!loadWindowSettings(true))
      setGeometry(
        (int)(qApp->desktop()->width() -  (qApp->desktop()->width() - (qApp->desktop()->width() / 2)) * 1.5) / 2,
        (int)(qApp->desktop()->height() - (qApp->desktop()->height() -  (qApp->desktop()->height() / 2)) * 1.5) / 2,
        (int)((qApp->desktop()->width() - (qApp->desktop()->width() / 2)) * 1.5),
        (int)((qApp->desktop()->height() - (qApp->desktop()->height() / 2)) * 1.5));
  }
  else  
    if ((!g_isMDI) || (canClose))
    {
      myResize(600,400);
      autoPlace();
    }
  m_pDatabaseTree->drawItems(itemRoot);
}

bool CConsoleWindow::getCanClose()
{
  return canClose;
}

void CConsoleWindow::setCaption (const QString &caption)
{
  treePanel->setCaption(caption);
  CMyWindow::setCaption(caption);
}

void CConsoleWindow::p_saveWindowSettings(QDockWindow *dw, const QString &c, CConfig *cfg)
{
  Dock d;
  bool inDock = findDockWindow(&d, ((CMyWindow *)qApp->mainWidget()), dw);  
  QString s;
  if (inDock && ((int) d != 0))
  {
    int m = 0;
    if ((d == DockTop) || (d == DockBottom))
      m = dw->height();
    else
      m = dw->width();
    s.sprintf("%d,%d,%d,%s", (dw->isVisible() ? 1 : 0), (int) d, m, (dw->area() != 0 ? (dw->area()->parent()->name()) : "null"));
  }
  else
    s.sprintf("%d,%d,%d,%s",1, 0, 0, "null");
  cfg->writeEntry(c, s);
}

void CConsoleWindow::saveWindowSettings()
{
  CMyWindow::saveWindowSettings();
  if ((!g_isMDI) || (canClose))
    return;
  CConfig *cfg = new CConfig(g_CONFIG_FILE);
  cfg->prepare();
  p_saveWindowSettings(treePanel, "TreePanel", cfg);
  p_saveWindowSettings(p_messageWindow, "MessagePanel", cfg);
  cfg->flush();
  delete cfg;
}

bool CConsoleWindow::p_loadWindowSettings(bool r, QDockWindow *dw, const QString &c, CConfig *cfg)
{
  bool ret = r;
  QString s = cfg->readStringEntry(c, QString::null);
  if (!s.isNull())
  {
    QRegExp rx("^(\\d+),(\\d+),(\\d+),(.+)");
    if (rx.search(s) != -1)
    {
      if (rx.cap(4) == "CApplicationWindow")
      {
        Dock d = (Dock) rx.cap(2).toInt();
        if ((int) d == 0)
          d = Qt::DockLeft;
        ((CMyWindow *)qApp->mainWidget())->addDockWindow(dw, d);
        int m = rx.cap(3).toInt();
        if (((d == DockTop) || (d == DockBottom)) && (m != 0))
          dw->setFixedExtentHeight(m);
        else
          dw->setFixedExtentWidth(m);
        if (rx.cap(1) != "1")
          dw->hide();
        ret = true;
      }
    }
  }  
  return ret;
}

bool CConsoleWindow::loadWindowSettings(bool b)
{
  bool ret = CMyWindow::loadWindowSettings(b);
  if ((!g_isMDI) || (canClose))
    return ret;
  CConfig *cfg = new CConfig(g_CONFIG_FILE);
  cfg->prepare();
  ret = p_loadWindowSettings(ret, treePanel, "TreePanel", cfg);
  ret = p_loadWindowSettings(ret, p_messageWindow, "MessagePanel", cfg);
  delete cfg;
  return ret;
}

void CConsoleWindow::beforeClose()
{
  m_pDatabaseTree->configureToolbars((CDatabaseTreeItem *)m_pDatabaseTree->firstChild());
  CMyWindow::beforeClose();
}

void CConsoleWindow::closeEvent(QCloseEvent * e)
{
  beforeClose();  
  if ((!g_isMDI) && (!canClose))
  {      
    if (g_confirmCritical)
      if ((QMessageBox::information(0, tr("Confirm Exit"), tr("Are you sure you want to Exit ?"),
        QMessageBox::Yes, QMessageBox::No) != QMessageBox::Yes))
      {
        e->ignore();
        return;
      }
    CMyWindow *w;
    QPtrListIterator<CMyWindow> it(g_WindowList);
    while ((w = it.current()) != 0 )
    {
      ++it;
      w->beforeClose();
    }
    e->accept();
  }
  else
  {
    if (!canClose)
    {
      e->ignore();
      hide();
    }
    else    
      e->accept();
  }  
}

CConsoleWindow::~CConsoleWindow()
{  
  if (treePanel != NULL)
  {
    treePanel->setCanClose(true);
    removeDockWindow (treePanel);
    treePanel->close();
    delete treePanel;
  }
  if ((!g_isMDI) && (!canClose))
    freeResources();
#ifdef DEBUG
  qDebug("~CConsoleWindow()");
#endif
}

void CConsoleWindow::UndockWindows()
{
  if ((treePanel->area() != 0) && (treePanel->area()->parent() != this))
    moveDockWindow(treePanel, DockLeft);  
}

