/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#include "CApplicationWindow.h"
#include "CSqlEditor.h"
#include <qmessagebox.h>

CApplicationWindow::CApplicationWindow( QWidget* parent,  const char* name, WFlags fl )
: CMyWindow( parent, name, fl, false)
{
  if ( !name )
 	  setName( "CApplicationWindow" );
  setMinimumSize(320, 240);
  setApplicationWidget(true);
  setCaption(QString(APPLICATION) + " " + QString(VERSION));
  setIcon(getPixmapIcon("applicationIcon"));
  setCentralWidget( new QWidget( this, "qt_central_widget"));  
  CApplicationWindowLayout = new QVBoxLayout(centralWidget(), 2, 2, "CApplicationWindowLayout");
  Q_CHECK_PTR(CApplicationWindowLayout);
  
  g_WorkSpace = new QWorkspace(centralWidget(), "WorkSpace" );
  Q_CHECK_PTR(g_WorkSpace);
  g_WorkSpace->setScrollBarsEnabled(true);
  
  CApplicationWindowLayout->addWidget(g_WorkSpace);
  
  new CConsoleMenu(this, menuBar(), "ConsoleMenu");
  
  m_pWindowMenu = new QPopupMenu( this );
  m_pWindowMenu->setCheckable( true );    
  menuBar()->insertItem(tr("&Window", "" ), m_pWindowMenu );
  
  new COptionsMenu(this, menuBar(), "OptionsMenu");
  new CHelpMenu(this, menuBar(), "HelpMenu");
  setDockEnabled(Qt::DockLeft, true);
  init_signals();
  if (!loadWindowSettings(true))
    setGeometry((int)(qApp->desktop()->width() - (qApp->desktop()->width() - (qApp->desktop()->width() / 2)) * 1.5) / 2,
      (int)(qApp->desktop()->height() - (qApp->desktop()->height() -  (qApp->desktop()->height() / 2)) * 1.5) / 2,
      (int)((qApp->desktop()->width() - (qApp->desktop()->width() / 2)) * 1.5),
      (int)((qApp->desktop()->height() - (qApp->desktop()->height() / 2)) * 1.5));
}

CApplicationWindow::~CApplicationWindow()
{  
  if (hasDockWindow(consoleWindow->treePanel))
  {
    removeDockWindow (consoleWindow->treePanel);
    consoleWindow->treePanel->close();
    delete consoleWindow->treePanel;
    consoleWindow->treePanel = NULL;
  }  

  if ((consoleWindow->messageWindow()->area() != 0) && (consoleWindow->messageWindow()->area()->parent() == this))
  {   
    CMessageWindow *m = consoleWindow->messageWindow();
    removeDockWindow (m);
    m->close();
    delete m;
    consoleWindow->setMessageWindow(0);
  }

#ifdef DEBUG
  qDebug( "~CApplicationWindow()");
#endif
  freeResources();
#ifdef DEBUG
  qDebug( "~CApplicationWindow() - freeResources");
#endif
}

void CApplicationWindow::closeEvent(QCloseEvent * e)
{
#ifdef DEBUG
  qDebug( "CApplicationWindow::closeEvent() - start");
#endif
  if (g_confirmCritical)
    if ((QMessageBox::information(0, tr("Confirm Exit"), tr("Are you sure you want to Exit ?"),
      tr("&Yes"), tr("&No")) != 0))
    {
      e->ignore();
      return;
    }
  beforeClose();
  QWidgetList openWindows = g_WorkSpace->windowList();
  if (openWindows.count() > 0)
    for ( int i = 0; i < int(openWindows.count()); ++i)
      ((CMyWindow *)openWindows.at(i))->beforeClose();
  emit undockwindows();
  e->accept();
#ifdef DEBUG
  qDebug( "CApplicationWindow::closeEvent() - end");
#endif
}

void CApplicationWindow::CloseSLOT()
{
  QWidget* wnd = (QWidget*)g_WorkSpace->activeWindow();  
  if (wnd)
    wnd->close();
}

void CApplicationWindow::windowActivated(int id)
{
  QWidget* wnd = g_WorkSpace->windowList().at(id);
  if (wnd)
    wnd->showNormal();
  wnd->setFocus();
}

void CApplicationWindow::consoleWindowDisplay(int id)
{
  if (consoleWindow->isHidden())
  {
    m_pWindowMenu->setItemChecked(id, true);
    myShowWindow(consoleWindow);
  }	
  windowActivated(id);
}

void CApplicationWindow::closeAllSLOT()
{
  QWidget *w;
  while ((w = g_WorkSpace->activeWindow()))
    w->close(true);
}

void CApplicationWindow::windowMenuAboutToShow()
{  
  m_pWindowMenu->clear();
  int consoleWindowId = m_pWindowMenu->insertItem(consoleWindow->caption(), this, SLOT(consoleWindowDisplay(int)));
  m_pWindowMenu->setItemParameter(consoleWindowId, 0);
  m_pWindowMenu->setItemChecked(consoleWindowId, !consoleWindow->isHidden());
  m_pWindowMenu->insertSeparator();
  
  int closeId = m_pWindowMenu->insertItem(getPixmapIcon("closeIcon"), tr("Cl&ose"), this, SLOT(CloseSLOT()));
  int closeAllId = m_pWindowMenu->insertItem(getPixmapIcon("closeAllIcon"), tr("Close Al&l"), this, SLOT(closeAllSLOT()));
  m_pWindowMenu->insertSeparator();
  int cascadeId = m_pWindowMenu->insertItem(getPixmapIcon("cascadeIcon"), tr("&Cascade"), g_WorkSpace, SLOT(cascade()));
  int tileId = m_pWindowMenu->insertItem(getPixmapIcon("tileIcon"), tr("&Tile"), g_WorkSpace, SLOT(tile()));
  QWidgetList openWindows = g_WorkSpace->windowList();
  if ( ((openWindows.count() <= 1) || (g_WorkSpace->windowList().isEmpty())) && (consoleWindow->isHidden()))
  {
    m_pWindowMenu->setItemEnabled( closeId, false);
    m_pWindowMenu->setItemEnabled( closeAllId, false);
    m_pWindowMenu->setItemEnabled( cascadeId, false);
    m_pWindowMenu->setItemEnabled( tileId, false);
  }
  else
    if (openWindows.count() > 1)
      m_pWindowMenu->insertSeparator();
    for ( int i = 1; i < int(openWindows.count()); ++i )
    {
      int id = m_pWindowMenu->insertItem(openWindows.at(i)->caption(), this, SLOT(windowActivated(int)));
      m_pWindowMenu->setItemParameter(id, i);
      m_pWindowMenu->setItemChecked(id, g_WorkSpace->activeWindow() == openWindows.at(i));
    }
}

void CApplicationWindow::init_signals()
{	
  connect(m_pWindowMenu, SIGNAL(aboutToShow()), this, SLOT(windowMenuAboutToShow()));
}

