/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef GLOBALS_H
#define GLOBALS_H

#ifdef WIN32
#include <windows.h>
#else
#include <stdlib.h>
#endif

#include <qstring.h>
#include <qdict.h>
#include <qintdict.h>
#include <qpixmap.h>
#include <qfont.h>

#include "CMyWindow.h"
#include "syntaxhighliter_sql.h"

class QApplication;
class QWorkspace;

class SQLKeyWord;
class DBKeyWord;
class CMySQLConnection;
class CMyWindow;
class SqlFormat;
class CHistoryView;
class QTranslator;
class CMessagePanel;
class CMyWindow;

extern int g_widgetID;
extern int g_serverID;
extern int g_historySize;
extern bool g_isMDI;
extern bool g_saveWorkspace;
extern bool g_confirmCritical;
extern bool g_syntaxHighlight;
extern bool g_parenthesesMatching;
extern bool g_completion;
extern QFont g_printerFont;
extern QString g_errorSoundFile;
extern QString g_informationSoundFile;
extern QString g_warningSoundFile;

extern QString g_CONNECTION_PATH;
extern QString g_CONFIG_FILE;
extern QString *g_TranslationsPath;
extern QString *g_CurrentLanguage;
extern QString *g_CurrentStyle;
extern QString *g_SyntaxFile;
extern CHistoryView * g_HistoryList;
extern QWorkspace *g_WorkSpace;
extern QTranslator *g_Translator;
extern QDict<QString> *g_PasswordDict;
extern QDict<QPixmap> *g_IconsDict;
extern QIntDict<QString> *g_ServersDict;
extern QDict<SQLKeyWord> *g_KeywordDict;
extern QIntDict<DBKeyWord> *g_DBKeywordDict;
extern QWidget *g_MainWidget;

extern const QPixmap getPixmapIcon(const QString &name);
extern void playSound(const QString &fileName);
extern bool tempFileName(const QString &path, QString &tmp);
extern QString capitalize(const QString &s);
extern void freeResources();
extern void setTranslation();
extern void myShowWindow(CMyWindow *wnd);
extern QString getSaveName(const QString &fileName, const QString &default_ext, const QString &ext_desc);
extern void saveToFile(QString &fileName, const QString &default_ext, const QString &ext_desc, const char * contents, CMessagePanel *m=0, bool writeBinary = false, uint len=0);
extern QString nice_time(ulong sec);
extern char *charReplace(char *, char, char);
extern QString charReplace(const QString &, const QChar &, const QString &);
extern bool validateAlphaNum(const QString &);
extern bool validateAlphaNum(QString *, const QChar & Replace);		
extern bool strInCSVList(const QString & lst, const QString & str, bool caseSensitive=false);
extern QString stripHtmlTags(const QString & str);
extern void striptags(char *rbuf);
extern QString booltostr(bool b);
extern QString booltoyesno(bool b);
extern bool strtobool(const QString & b);
extern QString getFileName(QString fileWithPath);
extern QIntDict<SqlFormat> *g_SqlEditorStyles;

//This stores a pointer to all "child" windows when the app doesn't run in MDI mode.
//It's needed to keep track of all child-windows so that we can free them when our application quits.
extern QPtrList<CMyWindow> g_WindowList;

#endif

