/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CUSERITEM_H
#define CUSERITEM_H

#include <qvariant.h>
#include <qlistview.h>
#include <qpopupmenu.h>
#include "CDatabaseTreeItem.h"
#include "CMySQLConnection.h"
#include "Config.h"

class CDatabaseTreeItem;

class CUserItemToolbar : public CToolBar
{
  Q_OBJECT

public:
  CUserItemToolbar(QMainWindow * parent);  
};

class CUserItem : public CDatabaseTreeItem
{     
public:
  CUserItem(CMyWindow *consoleWindow, CDatabaseTreeItem * parent, const QString &username = QString::null, const QString &hostname = QString::null, QWidgetStack *w = NULL);
  CUserItem(CMyWindow *consoleWindow, QListView * parent = 0, CMySQLConnection *mysql = 0, const QString &username = QString::null, const QString &hostname = QString::null, QWidgetStack *w = NULL);
  ~CUserItem();  
  void init_item(QWidgetStack *w, CMyWindow *consoleWindow);
  int displayMenu(const QPoint & pos);
  void processMenu(int res);
  void doubleClicked();
  QString getUserName() { return m_UserName; }
  QString getHostName() { return m_HostName; }

private:  
  bool deleteMySQL;
  QString m_UserName;
  QString m_HostName;
};

#endif

