/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CTOOLBAR_H
#define CTOOLBAR_H

#include <qtoolbutton.h>
#include <qtoolbar.h>
#include <qptrlist.h>

class QMainWindow;
class QPopupMenu;

class privateToolButton : public QToolButton
{
  Q_OBJECT
public:
  privateToolButton (int result, QWidget * parent, const char * name = 0 );
  privateToolButton (QPopupMenu *menu, QWidget * parent, const char * name = 0 );
  int getResult() { return m_result; }

protected:
  virtual void setConnectedToolbar(bool) {};

signals:
  void buttonClicked(int);

private slots:
  void Clicked();
  void PopupClicked();

private:
  int m_result;
  QPopupMenu *m_popup;
};


class CToolBar : public QToolBar
{ 
  Q_OBJECT
public:
  CToolBar (int type, QString label, QMainWindow * parent, const char * name);
  void addButton(int result, const QIconSet & iconset, const QString & textlabel);
  void addButton(int result, const QString & textlabel);
  void addButton(QPopupMenu * popup, const QIconSet & iconset, const QString & textlabel);
  QToolButton * Button(int idx);
  int getType() {return m_type;}
  void insertSeparator();
  void setVisible(bool v);
  void setMyVisible(bool v);
  bool getMyVisible();
  void readConfig();  

public slots:
  virtual void setMyEnabled (bool, int maj=0, int min=0);

signals:
  void buttonClicked(int, int);

protected:
  virtual void disableButtons(const int & = 0, const int & = 0) {};

protected slots:
  void enableAllButtons();

private slots:
  void privateButtonClicked(int);
  void myShow();
  void myShowWrite();
  void writeConfig();

private:
  privateToolButton * newButton(int result, const QString & textlabel);
  QPtrList<privateToolButton> buttonList;
  int m_type;
  bool myVisible;
};

#endif
