/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CTABLESLISTBOX_H
#define CTABLESLISTBOX_H

#include <qvariant.h>
#include <qdialog.h>
#include <qlistbox.h>
#include <qpopupmenu.h>
#include "CMySQLConnection.h"
#include "CMySQLQuery.h"
#include "Config.h"

class QListBoxItem;
class QListBox;

class CTablesListBox : public QListBox
{ 
  Q_OBJECT
    
public:
  CTablesListBox ( QWidget * parent, const char * name, CMySQLConnection *m, QString tableName = "");
  ~CTablesListBox();
  QString selectedTables();
  QStringList selectedTablesList();
  int count() { return numItems; }
protected slots:
  void refresh();
  void displayMenu( QListBoxItem *item, const QPoint & pos );
  
private:
  int numItems;
  CMySQLConnection *m_pMysql;
  QString m_tableName;
  void init();
  void showEvent( QShowEvent * );
  
signals:
  void notablesloaded();
};

#endif // CTABLESLISTBOX_H

