/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CTABLETOOLS_H
#define CTABLETOOLS_H

#include <qvariant.h>
#include <qwidgetstack.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <qptrlist.h> 
#include <qgroupbox.h>
#include <qcheckbox.h>
#include <qcursor.h>

class CTableTools; 
class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QCheckBox;
class QGroupBox;
class QPushButton;

#include "CQueryWindow.h"
#include "CMyWindow.h"
#include "CMySQLConnection.h"
#include "CMySQLQuery.h"
#include "CTablesListBox.h"
#include "Config.h"
#include "CSqlTable.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QFrame;
class QPushButton;
class QCheckBox;
class QGroupBox;

struct ToolOptions
{
  QString Display;
  QString Value;
  QCheckBox *checkBox;
};

class CTableTools : public CMyWindow
{ 
  Q_OBJECT
    
public:
  CTableTools(int type, QPtrList<ToolOptions> *options, QWidget* parent = 0, const char* name = 0, QWidgetStack * w = 0, CMySQLConnection *m = NULL, const QString &tableName = QString::null, int serverid = -1);
  ~CTableTools();
  QFrame* m_pTopFrame;
  CTablesListBox* tablesListBox;
  QPushButton* m_pExecutePushButton;
  QPushButton* m_pCancelPushButton;	
  QPushButton* PushButton4;
  static QPopupMenu *tableToolsMenu();
  static void processMenu(QWidgetStack * w, CMySQLConnection *m, int res, const QString & tableName=QString::null, int serverid=-1);
  static bool inRange(int res);
  
protected:  
  QWidgetStack *widgetStack;
  CMySQLConnection * mysql;  
  QString m_tableName;
  QPtrList<ToolOptions> *Options;
  int Type;
  
private:
  QHBoxLayout* Layout14;
  QVBoxLayout* CTableToolsLayout;
  QVBoxLayout* m_pTopFrameLayout;
  QGroupBox *pOptions;
  QGridLayout *pOptionsLayout;
  QGridLayout * Layout;
  int serverID;


protected slots:
  virtual void init();
  virtual void execute();
  virtual void create();
  virtual void NoTablesLoaded();
};

#endif // CTABLETOOLS_H

