/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CSQLTABLE_H
#define CSQLTABLE_H

#include <qvariant.h>
#include <qpopupmenu.h>
#include <qtable.h>
#include <qworkspace.h>
#include <qtimer.h>
#include <qdockwindow.h>

#include "CFieldEditorWindow.h"
#include "CMySQLConnection.h"
#include "CMySQLQuery.h"
#include "Config.h"

#ifndef IS_MUL_KEY
#define IS_MUL_KEY(n)	((n) & MULTIPLE_KEY_FLAG)
#endif

#ifndef IS_UNI_KEY
#define IS_UNI_KEY(n)	((n) & UNIQUE_KEY_FLAG)
#endif

#ifndef IS_BINARY_FIELD
#define IS_BINARY_FIELD(n) ((n) & BINARY_FLAG)
#endif

class QTable;
class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QLabel;
class QListView;
class QListViewItem;
class QLineEdit;
class QPushButton;

class privateEllipseBoxLineEdit : public QLineEdit
{
  Q_OBJECT
public:
  privateEllipseBoxLineEdit(QWidget *parent = 0, const char *name=0)
    :QLineEdit(parent, name)
  {
  }

protected:
  void mouseDoubleClickEvent(QMouseEvent * e)
  {
    emit doubleClicked((int) e->button());
  }

signals:
  void doubleClicked(int button);
};

class privateEllipseBox : public QWidget
{
  Q_OBJECT
public:
  privateEllipseBox( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  ~privateEllipseBox();
  privateEllipseBoxLineEdit* LineEdit;
  QPushButton* EllipseButton;
  void setText(const QString &t);
  QString text() const;
  void setTableItem(QTableItem *i);

signals:
  void buttonClicked(QTableItem *);
  void doubleClicked(int, QTableItem *);

private slots:
  void Clicked();
  void DoubleClicked(int);

private:
  QHBoxLayout* Form1Layout;
  QTableItem *TableItem;
};

class CEllipseTableItem : public QTableItem
{  
public:
  CEllipseTableItem( QTable *table, const QString &txt );
  QWidget *createEditor() const; 
  void setContentFromEditor(QWidget *w);
  void paint( QPainter *p, const QColorGroup &cg, const QRect &cr, bool selected );
  int rtti() const;
  void signalConnectButton(const QString & sig, QObject *rec, const QString & s);
  void signalConnectItem(const QString & sig, QObject *rec, const QString & s);
  void setReadOnly(bool b);
  void setFieldIndex(unsigned int idx);
  unsigned int getFieldIndex() { return fieldIndex; };
  unsigned int getFieldLength() { return fieldLength; };
  unsigned int getRowOffset() { return rowOffset; };
  void setBinaryField(bool b);
  bool isBinaryField() { return isBinary; };
  void setRowOffset(unsigned int offset);
  void setFieldLength(unsigned int len);
  void setFieldProperties(const QString &name, unsigned int idx, unsigned int offset);
  void setFieldName(const QString &name);
  QString getFieldName() { return fieldName; };
  QPoint EllipsePoint();

private:
  privateEllipseBox *eb;
  unsigned int fieldIndex;
  unsigned int fieldLength;
  unsigned int rowOffset;
  QString fieldName;
  bool isBinary;
  QString signal;
  QString slot;
  QObject * receiver;
  bool isConnected;
  QString signal2;
  QString slot2;
  QObject * receiver2;
  bool isConnected2;  
};

class CCheckTableItem : public QTableItem
{
public:
  CCheckTableItem( QTable *table, const QString &txt );
  QWidget *createEditor() const;
  void setContentFromEditor( QWidget *w );
  void paint( QPainter *p, const QColorGroup &cg, const QRect &cr, bool selected );
  void setChecked( bool b );
  bool isChecked() const;
  int rtti() const;
  
private:
  QCheckBox *cb;
  bool checked;
};

class privateCheckListItem : public QCheckListItem
{
public:
  privateCheckListItem( QListView * parent, const QString & text, int columnid);
  ~privateCheckListItem() {}
  int columnID;

private:
  void stateChange (bool s);  
  bool created;
};

class privateListView : public QListView
{
  Q_OBJECT

public:
  privateListView( QWidget * parent = 0, const char * name = 0, WFlags f = 0 );  
  ~privateListView() {}  
  void CheckBoxClicked(int c, bool s);

private slots:
  void displayMenu( QListViewItem *, const QPoint &, int );

signals:
  void showColumn(int c, bool s);
};


class privateCSqlTableColumns : public QDockWindow
{
  Q_OBJECT

public:
  privateCSqlTableColumns(QWidget * parent = 0, const char * name = 0, WFlags f = 0);
  ~privateCSqlTableColumns() {}  
  privateListView* Columns;

  QSize minimumSizeHint() const
  {
    return QSize(1, 1);
  }

  QSize sizeHint() const
  {  
    return QSize(1, 1);
  }  
};

class CSqlTable : public QTable
{
  Q_OBJECT
public:
  class Headers
  { 
  public:
    Headers(int s, const QString &l, const QIconSet &i)
      :size(s), label(l), icon(i)
    {      
    }
    int size;
    QString label;
    QIconSet icon;
  };

  CSqlTable (QWidget * parent = 0, const char * name = 0);
  CSqlTable (QWidget * parent, CMySQLConnection *conn, const QString & query);
  CSqlTable (QWidget * parent, CMySQLConnection *conn);
  ~CSqlTable();
  QString getSaveContents();
  void setAutoCloseEditors(bool c) { autoCloseEditors = c; }
  void setQuery(const QString & query);
  void setDatabaseConnection(CMySQLConnection *conn);
  CMySQLConnection *getDatabaseConnection() { return m_pDatabaseConnection; }
  QString getCurrentQuery() { return m_Query; }  
  void setNumCols(int r);  
  virtual QString getSaveTitle();
  void setSaveTitle(const QString &title);
  privateCSqlTableColumns *ColumnsWindow;  
  bool hasAutomaticFieldEditors() { return hasAutoFieldEditors; } ;  
  bool isMyReadOnly() { return myReadOnly; };
  void enableColumnsWindow(bool b);
  bool isColumnsWindowEnabled() { return columnsWindowEnabled; }
  void sortColumn( int col, bool ascending, bool wholeRows );

public slots:
  void setAutomaticFieldEditors(bool b) { hasAutoFieldEditors = b; };
  void setMyReadOnly(bool b) { myReadOnly = b; };
  void save();
  void saveQueryContents();
  void cancelQuery();
  virtual void reset();
  virtual void exec(const QString & qry, bool printAffected = true);
  virtual void exec(bool printAffected = true);
  void ShowColumn(int c, bool s);
  void setMaxCellTextSize(int s) { maxCellTextSize = s; };

signals:
  void startquery();
  void endquery();
  void executing(bool);

protected:
  QIntDict<bool> headerSort;
  QIntDict<Headers> headerDict;
  virtual void init();
  virtual void processMenu(int res, int row, int);
  virtual int displayMenu(const QPoint &);  
  CMySQLConnection *m_pDatabaseConnection;
  CMySQLQuery *Query;
  QString m_Query;
  bool m_cancel;
  QString tmpFileName;
  bool columnWindowFirstTimeShown;
  bool isExecuting;
  QPtrList<CFieldEditorWindow> *EditorList;
  bool eventFilter( QObject *, QEvent * );
  
protected slots:
  void headerPressed(int);
  void headerReleased(int);
  void closeEditors(bool force = false);
  void Sort (int col);
  virtual void Clicked ( int, int, int, const QPoint &) {};
  virtual void DoubleClicked ( int, int, int, const QPoint &);
  virtual void ContextMenuRequested(int, int, const QPoint &);

private slots:
  void EllipseButtonClicked(QTableItem *x=0);
  void EllipseItemDoubleClicked(int button = 0, QTableItem *x=0);
  void OpenTextEditor(QTableItem *x);
  void OpenImageEditor(QTableItem *x);
  void P_saveToFile(QTableItem *x);

private:
  bool autoCloseEditors;
  bool columnsWindowEnabled;
  bool hasAutoFieldEditors;
  bool myReadOnly;
  bool hasSaveTitle;  
  QString saveTitle;
  int maxCellTextSize;
};

#endif

