/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA
*/

#ifndef QSYNTAXHIGHLIGHTERSQL_H
#define QSYNTAXHIGHLIGHTERSQL_H

#include <qdict.h>
#include <qstringlist.h>
#include "qrichtext_p.h"
#include "CConfig.h"

class CConfig;
class DBKeyWord
{
public:
  DBKeyWord()
  {
    Databases.setAutoDelete(true);
    Fields.setAutoDelete(true);
    Tables.setAutoDelete(true);
  }

  void addDB(const QString &value)
  {
    if (Databases.size() <= (Databases.count() +1))
      Databases.resize(Databases.count() + 1);
    Databases.insert(value.lower(), new QString(value));
  }

  void addField(const QString &value)
  {
    if (Fields.size() <= (Fields.count() +1))
      Fields.resize(Fields.count() + 1);
    Fields.insert(value.lower(), new QString(value));
  }

  void addTable(const QString &value)
  {
    if (Tables.size() <= (Tables.count() +1))
      Tables.resize(Tables.count() + 1);
    Tables.insert(value.lower(), new QString(value));
  }

  friend class SyntaxHighlighter_SQL;
  friend class CSqlEditor;

private:
  QDict<QString> Databases;
  QDict<QString> Fields;
  QDict<QString> Tables;
};

class SQLKeyWord
{
public:

  enum Keyword_Type
  {
    Sql = 1,
    Date,
    Math,
    String,
    Statistics,
    Misc,
    Table,
    Field,
    Field_Type,
    Custom
  };  

  enum Highlight_Type
  {
    highlight_STANDARD = 0,
    highlight_KEYWORDS,
	  highlight_FIELD_TYPES,
	  highlight_TABLES_AND_FIELDS,
	  highlight_FUNCTIONS,
    highlight_VARIABLES,
    highlight_COMMENTS,
    highlight_CUSTOM,
    highlight_STRINGS,
    highlight_NUMBERS,
    highlight_PARENTHESES_MATCHING
  };

  SQLKeyWord(QDict<SQLKeyWord> *keyword_dict, const QString & keyword, Keyword_Type keyword_type, Highlight_Type highlight_type)
  {
    Keyword = keyword;
    Highlight = highlight_type;
    Type = keyword_type;
    if (keyword_dict->size() == keyword_dict->count() + 1)
      keyword_dict->resize(keyword_dict->count() + 5);
    keyword_dict->insert(keyword.lower(), this);
  }

  ~SQLKeyWord() {};
  QString Keyword;
  Highlight_Type Highlight;
  Keyword_Type Type;
};

class SqlFormat
{
public:
  SqlFormat(CConfig *cfg, const QString & displayname, const QString & realname, SQLKeyWord::Highlight_Type id, const QString & defaultfont, const QString & defaultcolor);
  ~SqlFormat();
  void setDefaultValues();
  void update(QFont *f, QColor *c, const QString &font, const QString &color);
  bool saveToCfg(CConfig *cfg);
  void setDefaults();
  QString displayName;
  QString realName;
  SQLKeyWord::Highlight_Type ID;

  QFont Font; //used for if the user cancels the dialog
  QColor Color;

  QFont m_font;  //store the font while working in the dialog
  QColor m_color;

  QFont dFont;  //default fonts
  QColor dColor;
};

class SyntaxHighlighter_SQL : public QTextPreProcessor
{
public:

  SyntaxHighlighter_SQL();
  virtual ~SyntaxHighlighter_SQL();
  void process( QTextDocument *doc, QTextParag *string, int start, bool invalidate = true);
  void loadSqlKeywords(QDict<SQLKeyWord> *keyword_dict);
  void loadDatabaseKeywords(int serverid);
  QTextFormat *format( int id );

private:
    void addFormat( int id, QTextFormat *f );
    void removeFormat( int id );
    QTextFormat *lastFormat;
    int lastFormatId;
    QIntDict<QTextFormat> formats;
    QDict<SQLKeyWord> KeywordDict;
    bool hasSqlSyntaxHighlighting;
    bool hasDatabaseSyntaxHighlighting;
    QDict<QString> FieldsList;
};

#endif
