/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA

  Modified by: Jorge del Conde

  Original Code Copyrighted by Trolltech AS
*/

#ifndef EDITOR_H
#define EDITOR_H

#include <qtextedit.h>
#include <qprinter.h>
#include "qrichtext_p.h"
#include <qpaintdevicemetrics.h>
#include <qprinter.h>
#include <qpaintdevice.h>

struct Config;
class ParenMatcher;
class EditorCompletion;
class EditorBrowser;
class QAccel;

class Editor : public QTextEdit
{
  Q_OBJECT
    
public:
  enum Selection
  {
    Error = 3,
    Step = 4
  };
  
  Editor(QWidget *parent, const char *name );
  ~Editor();
  virtual void load( const QString &fn );    
  QTextDocument *document() const { return QTextEdit::document(); }
  void placeCursor( const QPoint &p, QTextCursor *c ) { QTextEdit::placeCursor( p, c ); }
  void setDocument( QTextDocument *doc ) { QTextEdit::setDocument( doc ); }
  QTextCursor *textCursor() const { return QTextEdit::textCursor(); }
  void repaintChanged() { QTextEdit::repaintChanged(); }
  virtual EditorCompletion *completionManager() { return 0; }
  virtual EditorBrowser *browserManager() { return 0; }
  virtual void configChanged();
  Config *config() { return cfg; }
  void setErrorSelection( int line );
  void setStepSelection( int line );
  void clearStepSelection();
  void clearSelections();
  virtual bool supportsErrors() const { return TRUE; }
  virtual bool supportsBreakPoints() const { return TRUE; }
  virtual void makeFunctionVisible( QTextParag * ) {}
  void drawCursor( bool b ) { QTextEdit::drawCursor( b ); } 
  bool eventFilter( QObject *o, QEvent *e );
  
signals:
  void clearErrorMarker();
  void intervalChanged();
  
protected slots:
  void print();
  virtual void save() {};
  
private slots:
  void cursorPosChanged( QTextCursor *c );
  void doChangeInterval();
  void commentSelection();
  void uncommentSelection();
  
protected:
  ParenMatcher *parenMatcher;
  QString filename;
  Config *cfg;
  bool hasError;  
  QAccel *accelComment, *accelUncomment;
  
};

#endif
