/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CSQLEDITOR_H
#define CSQLEDITOR_H

#include <qfile.h>
#include <qregexp.h>
#include <qfile.h>
#include <qfiledialog.h>
#include <qpainter.h>
#include <qprinter.h>
#include <qpaintdevicemetrics.h>
#include <qsimplerichtext.h>
#include <qstringlist.h>
#include <qdragobject.h>
#include "editor.h"
#include "CMySQLConnection.h"

#include "Config.h"

class Editor;
class EditorCompletion;
class QDragObject;

class CSqlEditor : public Editor
{
  Q_OBJECT
public:  
  CSqlEditor (QWidget * parent, int serverid = -1, const char * name = 0, CMySQLConnection *m=0);
  ~CSqlEditor();
  static bool LoadSyntaxFile();  
  virtual EditorCompletion *completionManager() { return completion; }
  QString getSaveContents();
  virtual QString getSaveTitle();
  void setSaveTitle(const QString &title);
  
public slots:
  void save();  
  void openFile();
  void contentsDropEvent(QDropEvent *event );
  void contentsDragEnterEvent (QDragEnterEvent *event);

private:
  CMySQLConnection *mysql;
  bool delete_completion;
  QString tmpFileName;
  EditorCompletion *completion;
  int serverID;
  bool hasSaveTitle;
  QString saveTitle;
};

#endif

