/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CSHOWTABLEGROUPPROPERTIES_H
#define CSHOWTABLEGROUPPROPERTIES_H

#include "CSqlTable.h"
#include "CDatabaseTreeItem.h"
#include <qwidgetstack.h>
#include <qinputdialog.h>

class CSqlTable;

class CShowTableGroupProperties : public CSqlTable
{
  Q_OBJECT
public:
  CShowTableGroupProperties(QWidget * parent, CMySQLConnection *conn, CDatabaseTreeItem *parentitem, int serverid);  
  
private:  
  void DoubleClicked ( int, int, int, const QPoint &);
  int displayMenu(const QPoint &pos);
  void processMenu(int res, int row, int col);
  QWidgetStack *widgetStack;
  CDatabaseTreeItem *parentItem;
  int serverID;
};

#endif

