/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CQUERYWINDOW_H
#define CQUERYWINDOW_H

#include <qvariant.h>

#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qaction.h>
#include <qmenubar.h>
#include <qpopupmenu.h>
#include <qtoolbar.h>
#include <qimage.h>
#include <qpixmap.h>
#include <qsplitter.h>
#include <qhbox.h>
#include <qtoolbutton.h>
#include <qprogressbar.h>

#include "CMyWindow.h"
#include "CSqlEditor.h"
#include "CMySQLConnection.h"
#include "CMySQLQuery.h"
#include "Config.h"
#include "CSqlTable.h"
#include "CMessageWindow.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QAction;
class QActionGroup;
class QToolBar;
class QPopupMenu;
class CSqlEditor;
class CSqlTable;

class CQueryWindow : public CMyWindow
{ 
  Q_OBJECT
    
public:
  CQueryWindow( QWidget* parent, CMySQLConnection *m, int querytype, const QString & table=QString::null, int limit=0, unsigned short display=0xFFFF, int serverid=-1);
  CQueryWindow( QWidget* parent, QString caption, CMySQLConnection *m, const QString & sql, unsigned short display=0xFFFF, int serverid=-1);
  ~CQueryWindow();
  
  CSqlEditor* sqlView;
  CSqlTable *results;	
  
  CHistoryPanel *HistoryPanel;
  
public slots:
  void SelectionChanged();
  void showSqlPanel(bool s);
  void showGridPanel(bool s);
  void SqlAction();
  void GridAction();
  void ExecuteQuery();
  void CancelQuery();
  void SelectQuery();
  void MakeTableQuery();
  void UpdateQuery();
  void AppendQuery();
  void DeleteQuery();
  void processShowMessagesSlot();
  void ReloadHistoryList();
  void doExecuteQuery(const QString &);
  void setQuery(const QString &);
  
protected:
  QHBoxLayout* CQueryWindowLayout;
  void createForm(CMySQLConnection *m, int querytype, const QString & table, unsigned short display);

private slots:
  void disableButtons(bool);

private:
  CMySQLConnection *mysql;	
  QString m_defaultTable;
  int m_queryType;
  bool canClose;
  void closeEvent ( QCloseEvent * e );

  QProgressBar *saveProgress;
  QGridLayout * saveProgressLayout;

  QMenuBar *menubar;
  QMenuBar *queryMenubar;
  
  QPopupMenu *fileMenu;
  QPopupMenu *editMenu;
  QPopupMenu *queryMenu;
  
  QToolBar *toolBar;
  QToolBar *queryBar;
  
  QAction* sqlAction;
  QAction* gridAction;
  QAction* executeQueryAction;
  QAction* cancelQueryAction;
  
  QAction* fileOpenAction;
  QAction* filePrintAction;
  QAction* fileCloseAction;
  QAction* editUndoAction;
  QAction* editRedoAction;
  QAction* editCutAction;
  QAction* editCopyAction;
  QAction* editPasteAction;
  QAction* showMessagesAction;
  
  QToolButton *queryTypeButton;
  QToolButton *saveTypeButton;

  QPopupMenu *p_queryTypesMenu;
  QPopupMenu *p_saveTypesMenu;
  void init();
  QPixmap selectQuery;
  QPixmap newTableQuery;
  QPixmap updateQuery;
  QPixmap appendQuery;
  QPixmap deleteQuery;
  int serverID;
};

#endif // CQUERYWINDOW_H

