/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CMESSAGEWINDOW_H
#define CMESSAGEWINDOW_H

#include <qvariant.h>
#include <qwidget.h>
#include <qlabel.h>
#include <qlistview.h>
#include <qlayout.h>
#include <qpopmenu.h>
#include <qpixmap.h>
#include <qaction.h>
#include <qdockwindow.h> 
#include <qlistbox.h>
#include <qpushbutton.h>
#include <qtabwidget.h>
#include <qtextedit.h>
#include <qsize.h>
#include <qintdict.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QLabel;
class QDockWindow;
class CMessagePanel;

class CPanelListBox : public QListBox
{
  Q_OBJECT

public:
  CPanelListBox(QWidget * parent = 0, const char * name = 0, WFlags f = 0);    
  QSize minimumSizeHint() const { return QSize(1, 1); }
  QSize sizeHint() const { return QSize(1, 1); }
  void setCarriageReturn(const QString &s);
  void myInsertItem (const QPixmap & pixmap, const QString & text, int index = -1);
  void myInsertItem ( const QString & text, int index = -1 );
  QString realText(int idx);
  void setMaxDisplaySize(int len) { maxdisplay = len; };
  void setMessagePanel (CMessagePanel *m);

public slots:
  void Clear();

protected slots:
  virtual void displayMenu(QListBoxItem *, const QPoint &) {};

protected:  
  virtual void save();
  virtual void copy(QListBoxItem *);
  QString tmpFile;

private:
  int maxdisplay;
  CMessagePanel *msgPanel;
  QString enter;
  QString insertRealText(const QString &s);
  QIntDict<QString> realtext;
};

class CMessageListBox : public CPanelListBox
{
  Q_OBJECT

public:
  CMessageListBox(QWidget * parent = 0, const char * name = 0, WFlags f = 0);      

private slots:
  void displayMenu(QListBoxItem *, const QPoint &);
};

class CHistoryListBox : public CPanelListBox
{
  Q_OBJECT

public:
  CHistoryListBox(QWidget * parent = 0, const char * name = 0, WFlags f = 0);
  void enableMenuItems(bool b) { itemsEnabled = b; };

signals:
  void executequery();
  void realoadhistorylist();
  void dblClick(const QString &);

private slots:
  void emitDblClick(QListBoxItem * item);
  void displayMenu(QListBoxItem *, const QPoint &);

private:  
  bool itemsEnabled;
};

class CSqlDebugListBox : public CPanelListBox
{
  Q_OBJECT

public:
  CSqlDebugListBox(QWidget * parent = 0, const char * name = 0, WFlags f = 0);

private:
  void copy(QListBoxItem *);

private slots:
  void displayMenu(QListBoxItem *, const QPoint &);
};

class CMyPanel : public QWidget
{
  Q_OBJECT
public:
  CMyPanel(const QString &caption=QString::null);
  ~CMyPanel() {}
  void showMessage(const QString & m);
  void showMessage(const QPixmap & w, const QString & m);
  void setCarriageReturn(const QString &s);
  void setMaxDisplaySize(int len);
  void setMessagePanel(CMessagePanel *m);

public slots:
  void clear();

protected:  
  QVBoxLayout* Layout;
  void setPanelWidget(CPanelListBox *p);

private:
  CPanelListBox *panel;
};

class CHistoryPanel : public CMyPanel
{
  Q_OBJECT
public:
  CHistoryPanel(const QString &caption=QString::null);  
  QString getSelectedHintText();
  void History(const QString & m, bool append=true);

public slots:
  void disableMenuItems(bool);

signals:
  void itemSelected(const QString &);
  void reloadHistoryList();
  void executeQuery(const QString &);
  void doubleClicked(const QString &);

private slots:
  void emitExecuteQuery();
  void emitDoubleClicked(const QString &);
  void emitRealoadHistoryList();
  void setCurrentHint(QListBoxItem * i);
  void mouseClicked(int, QListBoxItem * i, const QPoint &);
  void DoubleClicked(QListBoxItem * i);

private:  
  CHistoryListBox *Panel;
};

class CSqlDebugPanel : public CMyPanel
{
  Q_OBJECT
public:
  CSqlDebugPanel(const QString &caption=QString::null);  
  QString getSelectedHintText();
  void SqlDebug(const QString & m);

signals:
  void itemSelected(const QString &);

private slots:
  void setCurrentHint(QListBoxItem * i);
  void mouseClicked(int, QListBoxItem * i, const QPoint &);

private:  
  CSqlDebugListBox *Panel;
};

class CMessagePanel : public CMyPanel
{
  Q_OBJECT
public:
  CMessagePanel(const QString &caption=QString::null);
  void Warning(const QString & m);
  void Critical(const QString & m);
  void Information(const QString & m);

private:  
  CMessageListBox *Panel;
};

class CMessageWindow : public QDockWindow
{
  Q_OBJECT

public:
  CMessageWindow (Place p = InDock, QWidget * parent = 0, const char * name = 0, WFlags f = 0) ;
  void setCarriageReturn(const QString &s);
  void addPanel(CMyPanel *panel);
  ~CMessageWindow() {} 
private:
  QTabWidget* Tabs;
  QString cr;
};

#endif // CMESSAGEWINDOW_H