/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CGENERALCONFIG_H
#define CGENERALCONFIG_H

#include <qvariant.h>
#include "syntaxhighliter_sql.h"
#include "CConfigDialog.h"
#include "Config.h"
#include "CConfig.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QCheckBox;
class QComboBox;
class QLabel;
class QLineEdit;
class QPushButton;
class QSpinBox;
class QListBox;
class QListBoxItem;
class privateTabConfig;

class p_SyntaxHighlight : public privateTabConfig
{ 
  Q_OBJECT
    
public:
  p_SyntaxHighlight( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );  
  void setDefaultValues(CConfig * conn = 0);
  bool save(CConfig *conn);

private slots:
  void Refresh();
  void BoldToggled(bool b);
  void ItalicToggled(bool b);
  void UnderlineToggled(bool b);
  void FontChanged(const QString &);
  void ValueChanged(int);
  void setSectionColor();
  void DefaultPushButtonClicked();

private:
  void init();
  void refreshPreview(const QFont & fnt, const QColor & clr);
  void setFontBoolValue(void (QFont::*member)(bool), bool value);  
  SqlFormat *findItem(uint i);
  QHBoxLayout* p_SyntaxHighlightLayout;
  QGridLayout* Layout12;
  QListBox* Sections;
  QLineEdit* Preview;
  QCheckBox* Underline;
  QLabel* sizeLabel;
  QSpinBox* Size;
  QCheckBox* Italic;
  QLabel* preveiwLabel;
  QCheckBox* Bold;
  QComboBox* Font;
  QPushButton* Color;
  QLabel* fontLabel;
  QLabel* colorLabel;
  QPushButton* DefaultPushButton;
};

class p_SqlEditor : public privateTabConfig
{ 
  Q_OBJECT
    
public:
  p_SqlEditor( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
  void setDefaultValues(CConfig * conn = 0);
  bool save(CConfig *conn);

private slots:
  void setSyntaxFile();
  
private:
  void init();
  QGridLayout* p_SqlEditorLayout;
  QCheckBox* Parentheses;
  QCheckBox* Completion;
  QLabel* SyntaxFileLabel;
  QLineEdit* SyntaxFile;
  QPushButton* SyntaxFileBrowse;
  QCheckBox* SyntaxHighlight;
};

class p_GeneralConfig : public privateTabConfig
{ 
  Q_OBJECT

public:
  p_GeneralConfig( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 ); 
  void setDefaultValues(CConfig * conn = 0);
  bool save(CConfig *conn);
  bool needRestart() { return p_needRestart; }

private slots:  
  void setTranslationsPath();  
  void refreshLanguageCombo();
  void refreshLanguageCombo(const QString &path);
  void setErrorFile();
  void setWarningFile();
  void setInformationFile();

private:
  void init();
  bool p_needRestart;
  QLineEdit* errorSoundFile;
  QLineEdit* translationsPath;
  QCheckBox* saveWorkspace;
  QLineEdit* informationSoundFile;
  QCheckBox* confirmCritical;
  QLineEdit* warningSoundFile;
  QComboBox* language;
  QSpinBox* historySize;
  QLabel* historyNumberLabel;
  QLabel* languageLabel;
  QLabel* informationSoundLabel;
  QLabel* warningSoundLabel;
  QLabel* errorSoundLabel;
  QLabel* translationsPathLabel;
  QPushButton* warningSoundBrowse;
  QPushButton* informationSoundBrowse;
  QPushButton* errorSoundBrowse;
  QPushButton* translationsBrowse;
  QGridLayout* p_GeneralConfigLayout;
};

class CGeneralConfig : public CConfigDialog
{ 
  Q_OBJECT
    
public:
  CGeneralConfig( QWidget* parent = 0,  const char* name=0);
  ~CGeneralConfig();
  static void PrepareSqlEditor(CConfig *cfg);
  static void Configure(bool startupSpecific = false);
  static void setStylePalette(QString style);    

private:
  bool needRestart;
  void okButtonClicked();
  p_GeneralConfig * General;
};

#endif // CGENERALCONFIG_H

