/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/
#ifndef CFIELDEDITOR_H
#define CFIELDEDITOR_H

#include <qvariant.h>
#include <qframe.h>
#include <qpushbutton.h>
#include <qtextedit.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qwidget.h>

#include "CMySQLConnection.h"
#include "CTextEditor.h"
#include "CMyWindow.h"
#include "Globals.h"
#include "Config.h"

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QFrame;
class QPushButton;
class QTextEdit;

class CFieldEditorWindow : public CSmallMyWindow
{ 
  Q_OBJECT
    
public:
  CFieldEditorWindow(QWidget* parent, QPtrList<CFieldEditorWindow> *editorList, const char* name = 0, CMySQLConnection *m=0, bool ro=false);
  ~CFieldEditorWindow();
  virtual void doResize(int, int) {} ;
  
protected:  
  QGridLayout* CFieldEditorWindowLayout;
  QHBoxLayout* Frame5Layout;
  QFrame* Frame5;
  QPushButton* applyPushButton;
  QPushButton* cancelPushButton;
  CMySQLConnection *mysql;  
  bool readOnly;
  QPtrList<CFieldEditorWindow> *EditorList;

private slots:
  void applyButtonClicked();

private:
  void init();  
};

#endif

