/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CDATABASETREE_H
#define CDATABASETREE_H

#include <qvariant.h>
#include <qlistview.h>
#include <qheader.h>
#include <qpopupmenu.h>
#include <qwidgetstack.h>
#include <qmenubar.h>
#include <qaction.h>
#include <qtoolbar.h>

#include "Config.h"
#include "CDatabaseTreeItem.h"
#include "CServerItem.h"
#include "CServerAdministrationItem.h"
#include "CUserAdminItem.h"
#include "CUserItem.h"
#include "CDatabaseGroupItem.h"
#include "CDatabaseItem.h"
#include "CTableGroupItem.h"
#include "CToolBar.h"
#include "CMyWindow.h"

class QListView;
class QWidgetStack;
class QAction;
class QActionGroup;
class QToolBar;
class CToolBar;

class CDatabaseTree : public QListView
{ 
  Q_OBJECT
    
public:		
  CDatabaseTree(QWidget * myparent, QWidget * parent, bool ismainwidget, const char * name = 0, WFlags f = 0);
  ~CDatabaseTree();
  QWidgetStack * widgetStack;	
  void drawItems(CDatabaseTreeItem * itemRoot = 0);
  void configureToolbars(CDatabaseTreeItem * item);
  
public slots:
  void refreshServers();
  void hideItemToolbars();

private:
  void displayMenu(const QPoint & pos);
  void init();
  bool defaultMenu;
  bool isMainWidget;
  bool isNewWindow;
  void startDrag();  
  void OpenInNewWindow(CDatabaseTreeItem *p_Item);  
  QPopupMenu* actionMenu;
  QPopupMenu* toolBarMenu;
  QToolBar *actionToolBar;
  QAction* registerServerAction;
  QAction* refreshAction;
  QAction* showTreeAction;
  QAction* closeAction;
  QAction* showMessagesAction;
  QPtrList<CToolBar> toolBars;
  CServerItemToolbar * ServerItemToolBar;
  CDatabaseGroupToolbar * DatabaseGroupToolBar;
  CDatabaseItemToolbar * DatabaseItemToolBar;
  CTableGroupToolbar * TableGroupToolBar;
  CTableItemToolbar * TableItemToolBar;  
  CServerAdministrationItemToolbar * ServerAdministrationItemToolBar;
  CUserAdminItemToolbar * UserAdminItemToolBar;
  CUserItemToolbar * UserItemToolBar;
  CMyWindow *ConsoleWindow;
  QString cfgname;

  bool automaticToolbars;

private slots:
  void addServers(bool all);
  void ConnectionRenamed (CDatabaseTreeItem *item, const QString &newName);
  void RightButtonClicked(QListViewItem *item, const QPoint & pos, int c);
  void Clicked( int button, QListViewItem * item, const QPoint & pos, int c );
  void DoubleClicked( QListViewItem *item);
  void Expanded( QListViewItem *item);
  void Collapsed( QListViewItem *item);
  void ItemRenamed( QListViewItem * item, int col, const QString & text);
  void CurrentChanged (QListViewItem *);
  void ReturnPressed (QListViewItem *);
  void SpacePressed (QListViewItem *);
  void processMenu(int res);
  void processRegisterServerSlot();
  void processRefreshSlot();
  void processShowTreeSlot();
  void ToolbarButtonClicked(int, int);
  void toolbarMenuAboutToShow();
  void automaticToolbarsSlot();  
  void enableToolbars(bool enable);
  void setVisibleToolbar(CToolBar *v);
  void processShowMessagesSlot();
};

#endif

