/* Copyright (C) 2002 MySQL AB & Jorge del Conde

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.
    
  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston,
  MA 02111-1307, USA 
*/

#ifndef CDATABASEITEM_H
#define CDATABASEITEM_H

#include <qvariant.h>
#include <qlistview.h>
#include <qpopupmenu.h>

#include "CDatabaseTreeItem.h"

#include "Config.h"

class CDatabaseTreeItem;

class CDatabaseItemToolbar : public CToolBar
{
  Q_OBJECT

public:
  CDatabaseItemToolbar(QMainWindow * parent);
  void setConnectedToolbar(bool connected);
};

class CDatabaseItem : public CDatabaseTreeItem
{     
public:
  CDatabaseItem(CMyWindow *consoleWindow, int serverid, CDatabaseTreeItem * parent, const QString &dbname, bool isconnected = false, QWidgetStack *w = NULL);
  CDatabaseItem(CMyWindow *consoleWindow, int serverid, QListView * parent = 0, CMySQLConnection *mysql = 0, const QString & = QString::null, bool isconnected = false, QWidgetStack *w= NULL);
  ~CDatabaseItem();
  bool isConnected() { return m_isConnected; }
  void setConnected(bool isconnected);
  void init_item(bool isconnected, const QString &dbname, QWidgetStack *w, CMyWindow *consoleWindow, int serverid);
  int displayMenu(const QPoint & pos);
  void processMenu(int res);
  void doubleClicked();

private:
  bool isRefreshing;
  bool m_isConnected;
  bool deleteMySQL;
  void startDrag();
  
};

#endif

